/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.widgets.editors.datacolumn;

import com.github.gwtbootstrap.client.ui.Image;
import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.AbstractEditor;
import org.dashbuilder.client.widgets.dataset.editor.widgets.editors.datacolumn.DataColumnTypeEditor;
import org.dashbuilder.common.client.validation.editors.ValueBoxEditorDecorator;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.client.validation.editors.DataColumnDefEditor;

@Dependent
public class DataColumnBasicEditor
extends AbstractEditor
implements DataColumnDefEditor {
    private static final int ICONS_SIZE = 16;
    private static DataColumnBasicEditorBinder uiBinder = (DataColumnBasicEditorBinder)GWT.create(DataColumnBasicEditorBinder.class);
    private String editorId;
    @UiField
    FlowPanel columnPanel;
    @UiField
    ValueBoxEditorDecorator<String> id;
    @UiField
    DataColumnTypeEditor columnType;
    @UiField
    @Editor.Ignore
    Image columnTypeImage;
    private boolean isEditMode;

    public DataColumnBasicEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setEditMode(true);
        this.columnTypeImage.setVisible(false);
        this.columnType.setSize(16, 16);
    }

    public void setOriginalType(ColumnType originalType) {
        this.columnType.setOriginalType(originalType);
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean isEditMode) {
        this.isEditMode = isEditMode;
        this.columnType.setEditMode(isEditMode);
        this.draw();
    }

    private void draw() {
        Image image = null;
        if (!this.isEditMode && this.columnType.getValue() != null) {
            image = DataColumnTypeEditor.buildTypeSelectorWidget((ColumnType)this.columnType.getValue());
        } else if (!this.isEditMode && this.columnType.getOriginalType() != null) {
            image = DataColumnTypeEditor.buildTypeSelectorWidget(this.columnType.getOriginalType());
        }
        if (image != null) {
            this.columnTypeImage.setUrl(image.getUrl());
            this.columnTypeImage.setTitle(image.getTitle());
            this.columnTypeImage.setSize("16px", "16px");
            this.columnTypeImage.setVisible(true);
            this.columnType.setVisible(false);
        } else {
            this.columnType.setVisible(true);
            this.columnTypeImage.setVisible(false);
        }
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<ColumnType> handler) {
        return this.columnType.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public void showErrors(List<EditorError> errors) {
        this.consumeErrors(errors);
    }

    @Override
    protected void consumeErrors(List<EditorError> errors) {
        for (EditorError error : errors) {
            if (!error.getEditor().equals((Object)this)) continue;
            error.setConsumed(true);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            DataColumnBasicEditor e = (DataColumnBasicEditor)((Object)obj);
            return this.editorId.equals(e.editorId);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.id.clear();
        this.columnType.clear();
    }

    static interface DataColumnBasicEditorBinder
    extends UiBinder<Widget, DataColumnBasicEditor> {
    }
}

