/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.animations;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.animation.client.AnimationScheduler;
import com.google.gwt.user.client.ui.Widget;

public class AlphaAnimation
extends Animation {
    private Widget widget;
    private boolean showing;

    public AlphaAnimation(Widget widget) {
        this.widget = widget;
    }

    public AlphaAnimation(AnimationScheduler scheduler, Widget widget) {
        super(scheduler);
        this.widget = widget;
    }

    protected void onStart() {
        super.onStart();
        this.showing = !this.widget.isVisible();
    }

    protected void onUpdate(double progress) {
        double alpha = this.showing ? progress : 1.0 - progress;
        this.applyAlpha(this.widget, alpha);
    }

    protected void onComplete() {
        super.onComplete();
        this.widget.setVisible(this.showing);
    }

    private void applyAlpha(Widget panel, double alpha) {
        if (alpha <= 1.0 && alpha >= 0.0) {
            panel.getElement().setAttribute("style", "filter: alpha(opacity=5);opacity: " + alpha);
        }
    }
}

