/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.displayer.client.DataSetEditHandler;
import org.dashbuilder.validations.dataset.DataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

public abstract class DataSetEditorWorkflow<T extends DataSetDef>
implements IsWidget {
    protected SyncBeanManager beanManager;
    protected DataSetClientServices clientServices;
    protected DataSetDefValidator dataSetDefValidator;
    protected Event<SaveRequestEvent> saveRequestEvent;
    protected Event<TestDataSetRequestEvent> testDataSetEvent;
    protected Event<CancelRequestEvent> cancelRequestEvent;
    public View view;
    protected T dataSetDef;
    protected Collection<ConstraintViolation<?>> violations = new ArrayList();
    protected Command flushCommand;
    protected Command stepValidator;
    final Command testButtonCommand = new Command(){

        public void execute() {
            DataSetEditorWorkflow.this.flush();
            DataSetEditorWorkflow.this.testDataSetEvent.fire((Object)new TestDataSetRequestEvent(DataSetEditorWorkflow.this));
        }
    };
    final Command saveButtonCommand = new Command(){

        public void execute() {
            DataSetEditorWorkflow.this.flush();
            DataSetEditorWorkflow.this.saveRequestEvent.fire((Object)new SaveRequestEvent(DataSetEditorWorkflow.this));
        }
    };
    final Command cancelButtonCommand = new Command(){

        public void execute() {
            DataSetEditorWorkflow.this.cancelRequestEvent.fire((Object)new CancelRequestEvent(DataSetEditorWorkflow.this));
        }
    };

    @Inject
    public DataSetEditorWorkflow(DataSetClientServices clientServices, DataSetDefValidator dataSetDefValidator, SyncBeanManager beanManager, Event<SaveRequestEvent> saveRequestEvent, Event<TestDataSetRequestEvent> testDataSetEvent, Event<CancelRequestEvent> cancelRequestEvent, View view) {
        this.clientServices = clientServices;
        this.dataSetDefValidator = dataSetDefValidator;
        this.beanManager = beanManager;
        this.saveRequestEvent = saveRequestEvent;
        this.cancelRequestEvent = cancelRequestEvent;
        this.testDataSetEvent = testDataSetEvent;
        this.view = view;
    }

    public void init() {
        this.view.init(this);
    }

    public void testDataSet(final TestDataSetCallback testDataSetCallback) {
        this.checkDataSetDefNotNull();
        this.getDataSetDef().setAllColumnsEnabled(true);
        this.getDataSetDef().setColumns(null);
        this.getDataSetDef().setDataSetFilter(null);
        DataSetDef editCloneWithoutCacheSettings = this.getDataSetDef().clone();
        editCloneWithoutCacheSettings.setCacheEnabled(false);
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(this.dataSetDef.getUUID())).rowOffset(0)).rowNumber(6)).buildLookup();
        try {
            DataSetEditHandler editHandler = new DataSetEditHandler(this.clientServices, lookup, editCloneWithoutCacheSettings);
            editHandler.lookupDataSet(new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    testDataSetCallback.onSuccess(dataSet);
                }

                public void notFound() {
                    testDataSetCallback.onError(new ClientRuntimeError(DataSetEditorConstants.INSTANCE.defNotFound()));
                }

                public boolean onError(ClientRuntimeError error) {
                    testDataSetCallback.onError(error);
                    return false;
                }
            });
        }
        catch (Exception e) {
            testDataSetCallback.onError(new ClientRuntimeError((Throwable)e));
        }
    }

    public DataSetEditorWorkflow flush() {
        if (this.flushCommand != null) {
            this.flushCommand.execute();
        }
        return this;
    }

    public DataSetEditorWorkflow showNextButton() {
        this.view.addButton(DataSetEditorConstants.INSTANCE.next(), DataSetEditorConstants.INSTANCE.next_description(), true, this.saveButtonCommand);
        return this;
    }

    public DataSetEditorWorkflow showTestButton() {
        this.view.addButton(DataSetEditorConstants.INSTANCE.test(), DataSetEditorConstants.INSTANCE.test_description(), true, this.testButtonCommand);
        return this;
    }

    public DataSetEditorWorkflow showBackButton() {
        this.view.addButton(DataSetEditorConstants.INSTANCE.back(), DataSetEditorConstants.INSTANCE.back_description(), false, this.cancelButtonCommand);
        return this;
    }

    public DataSetEditorWorkflow clearButtons() {
        this.view.clearButtons();
        return this;
    }

    public boolean hasErrors() {
        return !this.violations.isEmpty();
    }

    public T getDataSetDef() {
        return this.dataSetDef;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void flush(SimpleBeanEditorDriver driver) {
        this.checkDataSetDefNotNull();
        this.violations.clear();
        driver.flush();
        this.afterFlush();
        if (this.stepValidator != null) {
            this.stepValidator.execute();
        }
    }

    protected void afterFlush() {
    }

    protected void addViolations(Iterable<ConstraintViolation<?>> _violations) {
        if (_violations != null) {
            for (ConstraintViolation<?> _v : _violations) {
                this.violations.add(_v);
            }
        }
    }

    public DataSetEditorWorkflow clear() {
        this.dataSetDef = null;
        this.flushCommand = null;
        this.stepValidator = null;
        this.violations.clear();
        this.view.clearView();
        return this;
    }

    protected void checkDataSetDefNotNull() {
        this.checkDataSetDefNotNull(this.dataSetDef);
    }

    protected void checkDataSetDefNotNull(T def) {
        if (def == null) {
            throw new RuntimeException("Must call edit() before using the data set definition editor workflow methods.");
        }
    }

    public static interface TestDataSetCallback {
        public void onSuccess(DataSet var1);

        public void onError(ClientRuntimeError var1);
    }

    public static interface View
    extends UberView<DataSetEditorWorkflow> {
        public View add(IsWidget var1);

        public View addButton(String var1, String var2, boolean var3, Command var4);

        public View clearButtons();

        public View clearView();
    }
}

