/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefPreviewTable;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefPreviewTableTest {
    @Mock
    DisplayerLocator displayerLocator;
    @Mock
    DataSetClientServices dataSetClientServices;
    @Mock
    DataSetDefPreviewTable.View view;
    @Mock
    DataSetDef dataSetDef;
    private DataSetDefPreviewTable tested;
    final List<DataColumnDef> columnDefList = (List)Mockito.mock(List.class);
    final Displayer displayer = (Displayer)Mockito.mock(Displayer.class);
    final DisplayerListener displayerListener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
    final DisplayerSettings displayerSettings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.columnDefList.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSetDef.clone()).thenReturn((Object)this.dataSetDef);
        this.tested = new DataSetDefPreviewTable(this.displayerLocator, this.dataSetClientServices, this.view);
    }

    @Test
    public void testInit() throws Exception {
        this.tested.init();
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDisplayer((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testClear() throws Exception {
        this.tested.tableDisplayer = this.displayer;
        this.tested.clear();
        Assert.assertNull((Object)this.tested.tableDisplayer);
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setDisplayer((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    public void testShow() throws Exception {
        Mockito.when((Object)this.displayerSettings.getRenderer()).thenReturn((Object)"gwtcharts");
        this.tested.show(this.dataSetDef, this.columnDefList, this.displayerListener);
        Assert.assertNotNull((Object)this.tested.tableDisplayer);
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDisplayer((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testDraw() throws Exception {
        this.tested.tableDisplayer = this.displayer;
        this.tested.draw(this.displayerListener);
        ((Displayer)Mockito.verify((Object)this.displayer, (VerificationMode)Mockito.times((int)1))).addListener(new DisplayerListener[]{this.displayerListener});
        ((Displayer)Mockito.verify((Object)this.displayer, (VerificationMode)Mockito.times((int)1))).draw();
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setDisplayer((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefPreviewTable.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }
}

