/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.create;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.bean.BeanDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.BeanDataSetDefAttributesDriver;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.BeanDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.validations.dataset.BeanDataSetDefValidator;
import org.dashbuilder.validations.dataset.DataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class BeanDataSetBasicAttributesWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DataSetDefValidator dataSetDefValidator;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    BeanDataSetDef dataSetDef;
    @Mock
    BeanDataSetDefValidator beanDataSetDefValidator;
    @Mock
    DataSetDefBasicAttributesEditor basicAttributesEditor;
    @Mock
    BeanDataSetDefAttributesEditor beanDataSetDefAttributesEditor;
    @Mock
    DataSetEditorWorkflow.View view;
    private BeanDataSetBasicAttributesWorkflow presenter;

    @Before
    public void setup() throws Exception {
        this.presenter = new BeanDataSetBasicAttributesWorkflow(this.clientServices, this.dataSetDefValidator, this.beanManager, this.basicAttributesEditor, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.dataSetDefValidator.validatorFor((DataSetProviderType)Matchers.any(DataSetProviderType.class))).thenReturn((Object)this.beanDataSetDefValidator);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(BeanDataSetDefAttributesDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(BeanDataSetDefAttributesEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidate() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.validate();
        ((BeanDataSetDefValidator)Mockito.verify((Object)this.beanDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validateAttributes((BeanDataSetDef)Matchers.any(BeanDataSetDef.class), new Object[0]);
        ((BeanDataSetDefValidator)Mockito.verify((Object)this.beanDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validate((BeanDataSetDef)Matchers.any(BeanDataSetDef.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), new Object[0]);
    }
}

