/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.create;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.ElasticSearchDataSetDefAttributesDriver;
import org.dashbuilder.client.widgets.dataset.editor.elasticsearch.ElasticSearchDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.ElasticSearchDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.validations.dataset.DataSetDefValidator;
import org.dashbuilder.validations.dataset.ElasticSearchDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ElasticSearchDataSetBasicAttributesWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DataSetDefValidator dataSetDefValidator;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    ElasticSearchDataSetDef dataSetDef;
    @Mock
    ElasticSearchDataSetDefValidator elDataSetDefValidator;
    @Mock
    DataSetDefBasicAttributesEditor basicAttributesEditor;
    @Mock
    ElasticSearchDataSetDefAttributesEditor elDataSetDefAttributesEditor;
    @Mock
    DataSetEditorWorkflow.View view;
    private ElasticSearchDataSetBasicAttributesWorkflow presenter;

    @Before
    public void setup() throws Exception {
        this.presenter = new ElasticSearchDataSetBasicAttributesWorkflow(this.clientServices, this.dataSetDefValidator, this.beanManager, this.basicAttributesEditor, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.ELASTICSEARCH);
        Mockito.when((Object)this.dataSetDefValidator.validatorFor((DataSetProviderType)Matchers.any(DataSetProviderType.class))).thenReturn((Object)this.elDataSetDefValidator);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(ElasticSearchDataSetDefAttributesDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(ElasticSearchDataSetDefAttributesEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidate() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.validate();
        ((ElasticSearchDataSetDefValidator)Mockito.verify((Object)this.elDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validateAttributes(this.dataSetDef, new Object[0]);
        ((ElasticSearchDataSetDefValidator)Mockito.verify((Object)this.elDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validate((ElasticSearchDataSetDef)Matchers.any(ElasticSearchDataSetDef.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), new Object[0]);
    }
}

