/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.list.DropDownImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.gwtbootstrap3.client.ui.constants.Placement;

@Dependent
public class ColumnTypeEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.ColumnTypeEditor {
    DropDownImageListEditor<ColumnType> columnType;
    ColumnType originalColumnType;

    @Inject
    public ColumnTypeEditor(DropDownImageListEditor<ColumnType> columnType) {
        this.columnType = columnType;
    }

    @PostConstruct
    public void init() {
        Collection<ImageListEditor.Entry> entries = this.getDefaultEntries();
        this.columnType.setImageSize("16px", "16px");
        this.columnType.setEntries(entries);
    }

    public Widget asWidget() {
        return this.columnType.asWidget();
    }

    public void addHelpContent(String title, String content, Placement placement) {
        this.columnType.addHelpContent(title, content, placement);
    }

    public void setOriginalColumnType(ColumnType columnType) {
        this.originalColumnType = columnType;
        Collection<ImageListEditor.Entry> acceptableEntries = this.getAcceptableEntries(columnType);
        this.columnType.setEntries(acceptableEntries);
    }

    public DropDownImageListEditor<ColumnType> columnType() {
        return this.columnType;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(DataColumnDef value) {
        ColumnType ct = this.originalColumnType != null ? this.originalColumnType : (value != null ? value.getColumnType() : null);
        Collection<ImageListEditor.Entry> acceptableEntries = this.getAcceptableEntries(ct);
        this.columnType.setEntries(acceptableEntries);
    }

    public void setDelegate(EditorDelegate<DataColumnDef> delegate) {
    }

    private Collection<ImageListEditor.Entry> getAcceptableEntries(ColumnType type) {
        ArrayList<ImageListEditor.Entry> result = new ArrayList<ImageListEditor.Entry>();
        if (type != null) {
            if (ColumnType.DATE.equals((Object)type)) {
                result.add(this.buildEntry(ColumnType.DATE));
            } else if (ColumnType.LABEL.equals((Object)type)) {
                result.add(this.buildEntry(ColumnType.TEXT));
                result.add(this.buildEntry(ColumnType.LABEL));
            } else if (ColumnType.TEXT.equals((Object)type)) {
                result.add(this.buildEntry(ColumnType.TEXT));
            } else if (ColumnType.NUMBER.equals((Object)type)) {
                result.add(this.buildEntry(ColumnType.LABEL));
                result.add(this.buildEntry(ColumnType.NUMBER));
            }
        }
        return result;
    }

    protected Collection<ImageListEditor.Entry> getDefaultEntries() {
        ColumnType[] providerTypes = ColumnType.values();
        ArrayList<ImageListEditor.Entry> entries = new ArrayList<ImageListEditor.Entry>(providerTypes.length);
        for (ColumnType type : providerTypes) {
            ImageListEditor.Entry entry = this.buildEntry(type);
            entries.add(entry);
        }
        return entries;
    }

    private ImageListEditor.Entry buildEntry(ColumnType type) {
        String title = type.name();
        String text = type.name();
        SafeUri uri = this.getImageUri(type);
        return this.columnType.newEntry((Object)type, uri, new SafeHtmlBuilder().appendEscaped(title).toSafeHtml(), new SafeHtmlBuilder().appendEscaped(text).toSafeHtml());
    }

    SafeUri getImageUri(ColumnType type) {
        SafeUri result = null;
        switch (type) {
            case DATE: {
                result = DataSetClientResources.INSTANCE.images().dateIcon32().getSafeUri();
                break;
            }
            case NUMBER: {
                result = DataSetClientResources.INSTANCE.images().numberIcon32V3().getSafeUri();
                break;
            }
            case TEXT: {
                result = DataSetClientResources.INSTANCE.images().textIcon32().getSafeUri();
                break;
            }
            case LABEL: {
                result = DataSetClientResources.INSTANCE.images().labelIcon32().getSafeUri();
            }
        }
        return result;
    }

    public void isEditMode(boolean isEdit) {
        this.columnType.isEditMode(isEdit);
    }
}

