/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.list.HorizImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetDefProviderTypeEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefProviderTypeEditor {
    HorizImageListEditor<DataSetProviderType> provider;
    public View view;

    @Inject
    public DataSetDefProviderTypeEditor(HorizImageListEditor<DataSetProviderType> provider, View view) {
        this.provider = provider;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        Collection<ImageListEditor.Entry> entries = this.getDefaultEntries();
        this.provider.setEntries(entries);
        this.view.initWidgets((IsWidget)this.provider.view);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showErrors(List<EditorError> errors) {
    }

    public HorizImageListEditor<DataSetProviderType> provider() {
        return this.provider;
    }

    protected Collection<ImageListEditor.Entry> getDefaultEntries() {
        DataSetProviderType[] providerTypes = DataSetProviderType.values();
        ArrayList<ImageListEditor.Entry> entries = new ArrayList<ImageListEditor.Entry>(providerTypes.length);
        for (DataSetProviderType type : providerTypes) {
            if (!this.isSupported(type)) continue;
            String title = this.getTypeSelectorTitle(type);
            String text = this.getTypeSelectorText(type);
            SafeUri uri = this.getTypeSelectorImageUri(type);
            ImageListEditor.Entry entry = this.provider.newEntry((Object)type, uri, new SafeHtmlBuilder().appendEscaped(title).toSafeHtml(), new SafeHtmlBuilder().appendEscaped(text).toSafeHtml());
            entries.add(entry);
        }
        return entries;
    }

    private boolean isSupported(DataSetProviderType type) {
        switch (type) {
            case BEAN: {
                return true;
            }
            case CSV: {
                return true;
            }
            case SQL: {
                return true;
            }
            case ELASTICSEARCH: {
                return true;
            }
        }
        return false;
    }

    String getTypeSelectorTitle(DataSetProviderType type) {
        String description = null;
        switch (type) {
            case BEAN: {
                description = DataSetEditorConstants.INSTANCE.bean();
                break;
            }
            case CSV: {
                description = DataSetEditorConstants.INSTANCE.csv();
                break;
            }
            case SQL: {
                description = DataSetEditorConstants.INSTANCE.sql();
                break;
            }
            case ELASTICSEARCH: {
                description = DataSetEditorConstants.INSTANCE.elasticSearch();
            }
        }
        return description;
    }

    String getTypeSelectorText(DataSetProviderType type) {
        String description = null;
        switch (type) {
            case BEAN: {
                description = DataSetEditorConstants.INSTANCE.bean_description();
                break;
            }
            case CSV: {
                description = DataSetEditorConstants.INSTANCE.csv_description();
                break;
            }
            case SQL: {
                description = DataSetEditorConstants.INSTANCE.sql_description();
                break;
            }
            case ELASTICSEARCH: {
                description = DataSetEditorConstants.INSTANCE.elasticSearch_description();
            }
        }
        return description;
    }

    SafeUri getTypeSelectorImageUri(DataSetProviderType type) {
        SafeUri result = null;
        switch (type) {
            case BEAN: {
                result = DataSetClientResources.INSTANCE.images().javaIcon160().getSafeUri();
                break;
            }
            case CSV: {
                result = DataSetClientResources.INSTANCE.images().csvIcon160().getSafeUri();
                break;
            }
            case SQL: {
                result = DataSetClientResources.INSTANCE.images().sqlIcon160().getSafeUri();
                break;
            }
            case ELASTICSEARCH: {
                result = DataSetClientResources.INSTANCE.images().elIcon160().getSafeUri();
            }
        }
        return result;
    }

    public static interface View
    extends UberView<DataSetDefProviderTypeEditor> {
        public void initWidgets(IsWidget var1);
    }
}

