/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.dashbuilder.client.widgets.dataset.editor.DataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.DataSetDefEditor;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.validations.dataset.DataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.mvp.Command;

public abstract class DataSetEditWorkflow<T extends DataSetDef, E extends DataSetDefEditor<? super T>>
extends DataSetEditorWorkflow<T> {
    protected SimpleBeanEditorDriver<T, E> driver;
    protected E editor;

    @Inject
    public DataSetEditWorkflow(DataSetClientServices clientServices, DataSetDefValidator dataSetDefValidator, SyncBeanManager beanManager, Event<SaveRequestEvent> saveRequestEvent, Event<TestDataSetRequestEvent> testDataSetEvent, Event<CancelRequestEvent> cancelRequestEvent, DataSetEditorWorkflow.View view) {
        super(clientServices, dataSetDefValidator, beanManager, saveRequestEvent, testDataSetEvent, cancelRequestEvent, view);
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    protected abstract Class<? extends SimpleBeanEditorDriver<T, E>> getDriverClass();

    protected abstract Class<? extends E> getEditorClass();

    protected abstract Iterable<ConstraintViolation<?>> validate(boolean var1, boolean var2, boolean var3);

    public DataSetEditWorkflow edit(T definition, List<DataColumnDef> allColumns) {
        this.clear();
        this.dataSetDef = definition;
        this.checkDataSetDefNotNull();
        this.driver = (SimpleBeanEditorDriver)this.beanManager.lookupBean(this.getDriverClass(), new Annotation[0]).newInstance();
        this.editor = (DataSetDefEditor)this.beanManager.lookupBean(this.getEditorClass(), new Annotation[0]).newInstance();
        this.driver.initialize(this.editor);
        this.editor.setAcceptableValues(allColumns);
        this.driver.edit(definition);
        this.flushCommand = new Command(){

            public void execute() {
                DataSetEditWorkflow.this.flush(DataSetEditWorkflow.this.driver);
            }
        };
        this.stepValidator = new Command((DataSetDef)definition){
            final /* synthetic */ DataSetDef val$definition;
            {
                this.val$definition = dataSetDef;
            }

            public void execute() {
                boolean isCacheEnabled = this.val$definition.isCacheEnabled();
                boolean isPushEnabled = this.val$definition.isPushEnabled();
                boolean isRefreshEnabled = this.val$definition.getRefreshTime() != null;
                Iterable<ConstraintViolation<?>> violations = DataSetEditWorkflow.this.validate(isCacheEnabled, isPushEnabled, isRefreshEnabled);
                DataSetEditWorkflow.this.driver.setConstraintViolations(violations);
                DataSetEditWorkflow.this.addViolations(violations);
            }
        };
        this.view.clearView();
        this.view.add(this.getWidget());
        return this;
    }

    public E getEditor() {
        return this.editor;
    }

    @Override
    protected void afterFlush() {
        super.afterFlush();
        if (!this.getEditor().refreshEditor().isRefreshEnabled()) {
            this.dataSetDef.setRefreshTime(null);
        }
    }

    protected DataSetEditor getWidget() {
        return (DataSetEditor)this.editor;
    }

    public DataSetEditorWorkflow showConfigurationTab() {
        this.getWidget().showConfigurationTab();
        return this;
    }

    public DataSetEditorWorkflow showPreviewTab() {
        this.getWidget().showPreviewTab();
        return this;
    }

    public DataSetEditorWorkflow showAdvancedTab() {
        this.getWidget().showAdvancedTab();
        return this;
    }

    void _setDataSetDef(T def) {
        this.dataSetDef = def;
    }
}

