/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.csv;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.file.FileUploadEditor;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;

@Dependent
public class CSVDataSetDefAttributesEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.CSVDataSetDefAttributesEditor {
    DataSetClientServices dataSetClientServices;
    ValueBoxEditor<String> fileURL;
    FileUploadEditor filePath;
    ValueBoxEditor<Character> separatorChar;
    ValueBoxEditor<Character> quoteChar;
    ValueBoxEditor<Character> escapeChar;
    ValueBoxEditor<String> datePattern;
    ValueBoxEditor<String> numberPattern;
    public View view;
    CSVDataSetDef value;
    boolean isUsingFilePath = true;

    @Inject
    public CSVDataSetDefAttributesEditor(DataSetClientServices dataSetClientServices, ValueBoxEditor<String> fileURL, FileUploadEditor filePath, ValueBoxEditor<Character> separatorChar, ValueBoxEditor<Character> quoteChar, ValueBoxEditor<Character> escapeChar, ValueBoxEditor<String> datePattern, ValueBoxEditor<String> numberPattern, View view) {
        this.dataSetClientServices = dataSetClientServices;
        this.fileURL = fileURL;
        this.filePath = filePath;
        this.separatorChar = separatorChar;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.datePattern = datePattern;
        this.numberPattern = numberPattern;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.fileURL.view, (IsWidget)this.filePath.view, this.separatorChar.view, this.quoteChar.view, this.escapeChar.view, this.datePattern.view, this.numberPattern.view);
        this.fileURL.addHelpContent(DataSetEditorConstants.INSTANCE.csv_URL(), DataSetEditorConstants.INSTANCE.csv_URL_description(), Placement.BOTTOM);
        this.filePath.addHelpContent(DataSetEditorConstants.INSTANCE.csv_filePath(), DataSetEditorConstants.INSTANCE.csv_filePath_description(), Placement.BOTTOM);
        this.separatorChar.addHelpContent(DataSetEditorConstants.INSTANCE.csv_sepChar(), DataSetEditorConstants.INSTANCE.csv_sepChar_description(), Placement.BOTTOM);
        this.quoteChar.addHelpContent(DataSetEditorConstants.INSTANCE.csv_quoteChar(), DataSetEditorConstants.INSTANCE.csv_quoteChar_description(), Placement.BOTTOM);
        this.escapeChar.addHelpContent(DataSetEditorConstants.INSTANCE.csv_escapeChar(), DataSetEditorConstants.INSTANCE.csv_escapeChar_description(), Placement.BOTTOM);
        this.datePattern.addHelpContent(DataSetEditorConstants.INSTANCE.csv_datePattern(), DataSetEditorConstants.INSTANCE.csv_datePattern_description(), Placement.BOTTOM);
        this.numberPattern.addHelpContent(DataSetEditorConstants.INSTANCE.csv_numberPattern(), DataSetEditorConstants.INSTANCE.csv_numberPattern_description(), Placement.BOTTOM);
        this.filePath.configure("csvFileUpload", new FileUploadEditor.FileUploadEditorCallback(){

            public String getUploadFileName() {
                return CSVDataSetDefAttributesEditor.this.value.getUUID() + ".csv";
            }

            public String getUploadFileUrl() {
                String csvPath = "default://master@datasets/tmp/" + CSVDataSetDefAttributesEditor.this.value.getUUID() + ".csv";
                return CSVDataSetDefAttributesEditor.this.dataSetClientServices.getUploadFileUrl(csvPath);
            }
        });
        this.view.showFilePathInput();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public ValueBoxEditor<String> fileURL() {
        return this.fileURL;
    }

    public FileUploadEditor filePath() {
        return this.filePath;
    }

    public ValueBoxEditor<Character> separatorChar() {
        return this.separatorChar;
    }

    public ValueBoxEditor<Character> quoteChar() {
        return this.quoteChar;
    }

    public ValueBoxEditor<Character> escapeChar() {
        return this.escapeChar;
    }

    public ValueBoxEditor<String> datePattern() {
        return this.datePattern;
    }

    public ValueBoxEditor<String> numberPattern() {
        return this.numberPattern;
    }

    public boolean isUsingFilePath() {
        return this.isUsingFilePath;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(CSVDataSetDef value) {
        this.value = value;
        if (value != null && value.getFileURL() != null) {
            this.useFileURL();
        } else {
            this.useFilePath();
        }
    }

    public void setDelegate(EditorDelegate<CSVDataSetDef> delegate) {
    }

    void onUseFilePathButtonClick() {
        this.useFilePath();
    }

    void onUseFileURLButtonClick() {
        this.useFileURL();
    }

    void useFilePath() {
        this.isUsingFilePath = true;
        this.view.showFilePathInput();
    }

    void useFileURL() {
        this.isUsingFilePath = false;
        this.view.showFileURLInput();
    }

    public static interface View
    extends UberView<CSVDataSetDefAttributesEditor> {
        public void initWidgets(ValueBoxEditor.View var1, IsWidget var2, ValueBoxEditor.View var3, ValueBoxEditor.View var4, ValueBoxEditor.View var5, ValueBoxEditor.View var6, ValueBoxEditor.View var7);

        public void showFilePathInput();

        public void showFileURLInput();
    }
}

