/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.BeanDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.CSVDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.DataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.DataSetProviderTypeWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.ElasticSearchDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.SQLDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.BeanDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.CSVDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.DataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.ElasticSearchDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.SQLDataSetEditWorkflow;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@Dependent
public class DataSetEditorWorkflowFactory {
    SyncBeanManager beanManager;
    DataSetProviderTypeWorkflow providerTypeWorkflow;

    @Inject
    public DataSetEditorWorkflowFactory(SyncBeanManager beanManager, DataSetProviderTypeWorkflow providerTypeWorkflow) {
        this.beanManager = beanManager;
        this.providerTypeWorkflow = providerTypeWorkflow;
    }

    public DataSetEditWorkflow edit(DataSetProviderType type) {
        boolean isSQL = type != null && DataSetProviderType.SQL.equals((Object)type);
        boolean isBean = type != null && DataSetProviderType.BEAN.equals((Object)type);
        boolean isCSV = type != null && DataSetProviderType.CSV.equals((Object)type);
        boolean isEL = type != null && DataSetProviderType.ELASTICSEARCH.equals((Object)type);
        Class workflowClass = null;
        if (isSQL) {
            workflowClass = SQLDataSetEditWorkflow.class;
        } else if (isCSV) {
            workflowClass = CSVDataSetEditWorkflow.class;
        } else if (isBean) {
            workflowClass = BeanDataSetEditWorkflow.class;
        } else if (isEL) {
            workflowClass = ElasticSearchDataSetEditWorkflow.class;
        }
        return (DataSetEditWorkflow)this.beanManager.lookupBean(workflowClass, new Annotation[0]).newInstance();
    }

    public DataSetProviderTypeWorkflow providerType() {
        return this.providerTypeWorkflow;
    }

    public DataSetBasicAttributesWorkflow basicAttributes(DataSetProviderType type) {
        boolean isSQL = type != null && DataSetProviderType.SQL.equals((Object)type);
        boolean isBean = type != null && DataSetProviderType.BEAN.equals((Object)type);
        boolean isCSV = type != null && DataSetProviderType.CSV.equals((Object)type);
        boolean isEL = type != null && DataSetProviderType.ELASTICSEARCH.equals((Object)type);
        Class workflowClass = null;
        if (isSQL) {
            workflowClass = SQLDataSetBasicAttributesWorkflow.class;
        } else if (isCSV) {
            workflowClass = CSVDataSetBasicAttributesWorkflow.class;
        } else if (isBean) {
            workflowClass = BeanDataSetBasicAttributesWorkflow.class;
        } else if (isEL) {
            workflowClass = ElasticSearchDataSetBasicAttributesWorkflow.class;
        }
        return (DataSetBasicAttributesWorkflow)this.beanManager.lookupBean(workflowClass, new Annotation[0]).newInstance();
    }
}

