/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetPanel;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DataSetExplorer
implements IsWidget {
    Instance<DataSetPanel> panelInstances;
    DataSetClientServices clientServices;
    View view;
    List<DataSetPanel> panels = new LinkedList<DataSetPanel>();

    @Inject
    public DataSetExplorer(Instance<DataSetPanel> panelInstances, DataSetClientServices clientServices, View view) {
        this.panelInstances = panelInstances;
        this.clientServices = clientServices;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show() {
        this.clear();
        this.clientServices.getPublicDataSetDefs((RemoteCallback)new RemoteCallback<List<DataSetDef>>(){

            public void callback(List<DataSetDef> dataSetDefs) {
                if (dataSetDefs != null && !dataSetDefs.isEmpty()) {
                    for (DataSetDef def : dataSetDefs) {
                        DataSetExplorer.this.addDataSetDef(def);
                    }
                }
            }
        });
    }

    private void addDataSetDef(DataSetDef def) {
        if (this.getDataSetPanel(def.getUUID()) == null) {
            DataSetPanel panel = (DataSetPanel)this.panelInstances.get();
            this.panels.add(panel);
            panel.show(def, "dataSetsExplorerPanelGroup");
            this.view.addPanel(panel.view);
        }
    }

    private void updateDataSetDef(DataSetDef def) {
        DataSetPanel panel = this.getDataSetPanel(def.getUUID());
        if (panel != null) {
            panel.show(def, "dataSetsExplorerPanelGroup");
            panel.close();
        }
    }

    private DataSetPanel getDataSetPanel(String uuid) {
        if (uuid != null) {
            for (DataSetPanel panel : this.panels) {
                if (!panel.getDataSetDef().getUUID().equals(uuid)) continue;
                return panel;
            }
        }
        return null;
    }

    private void clear() {
        this.panels.clear();
        this.view.clear();
    }

    void onDataSetDefRegisteredEvent(@Observes DataSetDefRegisteredEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        DataSetDef def = event.getDataSetDef();
        if (def != null && def.isPublic()) {
            this.addDataSetDef(def);
        }
    }

    void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        DataSetDef def = event.getNewDataSetDef();
        if (def != null && def.isPublic()) {
            this.updateDataSetDef(def);
        }
    }

    void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        DataSetDef def = event.getDataSetDef();
        if (def != null && def.isPublic()) {
            this.show();
        }
    }

    public static interface View
    extends UberView<DataSetExplorer> {
        public View addPanel(DataSetPanel.View var1);

        public View clear();
    }
}

