/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.event.EditDataSetEvent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetSummary;
import org.dashbuilder.client.widgets.resources.i18n.DataSetExplorerConstants;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.dashbuilder.dataset.def.DataSetDef;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetPanel
implements IsWidget {
    DataSetSummary dataSetSummary;
    Event<EditDataSetEvent> editDataSetEvent;
    View view;
    DataSetDef def;

    @Inject
    public DataSetPanel(DataSetSummary dataSetSummary, Event<EditDataSetEvent> editDataSetEvent, View view) {
        this.dataSetSummary = dataSetSummary;
        this.editDataSetEvent = editDataSetEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.configure(this.dataSetSummary.view);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show(DataSetDef def, String parentPanelId) {
        this.def = def;
        if (def != null) {
            String name = def.getName();
            SafeUri typeIconUri = this.getTypeIconUri(def);
            String typeName = this.getTypeIconTitle(def);
            this.view.showHeader(def.getUUID(), parentPanelId, typeIconUri, typeName, name);
        }
    }

    public void close() {
        this.view.hideSummary();
    }

    public void disable() {
        this.view.disableActionButton();
    }

    public DataSetDef getDataSetDef() {
        return this.def;
    }

    void open() {
        this.dataSetSummary.show(this.def);
        this.view.showSummary();
        this.view.enableActionButton(DataSetExplorerConstants.INSTANCE.edit(), new ClickHandler(){

            public void onClick(ClickEvent clickEvent) {
                DataSetPanel.this.editDataSetEvent.fire((Object)new EditDataSetEvent(DataSetPanel.this.def));
            }
        });
    }

    SafeUri getTypeIconUri(DataSetDef dataSetDef) {
        switch (dataSetDef.getProvider()) {
            case BEAN: {
                return DataSetClientResources.INSTANCE.images().javaIcon32().getSafeUri();
            }
            case CSV: {
                return DataSetClientResources.INSTANCE.images().csvIcon32().getSafeUri();
            }
            case SQL: {
                return DataSetClientResources.INSTANCE.images().sqlIcon32().getSafeUri();
            }
            case ELASTICSEARCH: {
                return DataSetClientResources.INSTANCE.images().elIcon32().getSafeUri();
            }
        }
        return null;
    }

    String getTypeIconTitle(DataSetDef dataSetDef) {
        switch (dataSetDef.getProvider()) {
            case BEAN: {
                return DataSetExplorerConstants.INSTANCE.bean();
            }
            case CSV: {
                return DataSetExplorerConstants.INSTANCE.csv();
            }
            case SQL: {
                return DataSetExplorerConstants.INSTANCE.sql();
            }
            case ELASTICSEARCH: {
                return DataSetExplorerConstants.INSTANCE.el();
            }
        }
        return null;
    }

    public static interface View
    extends UberView<DataSetPanel> {
        public View configure(DataSetSummary.View var1);

        public View showHeader(String var1, String var2, SafeUri var3, String var4, String var5);

        public View showSummary();

        public View hideSummary();

        public View enableActionButton(String var1, ClickHandler var2);

        public View disableActionButton();
    }
}

