/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.resources.i18n.DataSetExplorerConstants;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetSummary
implements IsWidget {
    private static final String ESTIMATIONS_FORMAT = "#,###.0";
    private static final String ICON_COLOR_DEFAULT = "black";
    private static final String ICON_COLOR_ERROR = "red";
    DataSetClientServices clientServices;
    Event<ErrorEvent> errorEvent;
    View view;

    @Inject
    public DataSetSummary(DataSetClientServices clientServices, Event<ErrorEvent> errorEvent, View view) {
        this.clientServices = clientServices;
        this.errorEvent = errorEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show(final DataSetDef def) {
        if (def != null) {
            boolean isShowBackendCache = def.getProvider() != null && !DataSetProviderType.BEAN.equals((Object)def.getProvider()) && !DataSetProviderType.CSV.equals((Object)def.getProvider());
            Boolean isCacheEnabled = isShowBackendCache ? Boolean.valueOf(def.isCacheEnabled()) : null;
            boolean isPushEnabled = def.isPushEnabled();
            boolean isRefreshEnabled = def.getRefreshTime() != null;
            this.view.showStatusPanel(isCacheEnabled, isPushEnabled, isRefreshEnabled);
            this.showLoadingIcon();
            this.getMetadata(def, new DataSetMetadataCallback(){

                public void callback(DataSetMetadata metadata) {
                    int estimatedSize = metadata.getEstimatedSize();
                    int rowCount = metadata.getNumberOfRows();
                    DataSetSummary.this.view.showSizePanel(DataSetSummary.this.humanReadableRowCount(rowCount) + " " + DataSetExplorerConstants.INSTANCE.rows(), DataSetSummary.this.humanReadableByteCount(estimatedSize));
                }

                public void notFound() {
                    DataSetSummary.this.showErrorIcon();
                    DataSetSummary.this.showError(def.getUUID(), DataSetExplorerConstants.INSTANCE.notFound());
                }

                public boolean onError(ClientRuntimeError error) {
                    DataSetSummary.this.showErrorIcon();
                    DataSetSummary.this.showError(def.getUUID(), error);
                    return false;
                }
            });
        }
    }

    String humanReadableByteCount(long bytes) {
        String _b = " " + DataSetExplorerConstants.INSTANCE.bytes();
        int unit = 1024;
        if (bytes < (long)unit) {
            return Long.toString(bytes) + _b;
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + _b;
        return NumberFormat.getFormat((String)ESTIMATIONS_FORMAT).format((double)bytes / Math.pow(unit, exp)) + pre;
    }

    String humanReadableRowCount(long rows) {
        int unit = 1000;
        if (rows < (long)unit) {
            return Long.toString(rows);
        }
        int exp = (int)(Math.log(rows) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return NumberFormat.getFormat((String)ESTIMATIONS_FORMAT).format((double)rows / Math.pow(unit, exp)) + pre;
    }

    private void getMetadata(DataSetDef def, DataSetMetadataCallback callback) {
        try {
            this.clientServices.fetchMetadata(def.getUUID(), callback);
        }
        catch (Exception e) {
            this.showError(def.getUUID(), e);
        }
    }

    void showLoadingIcon() {
        this.view.showSizePanelIcon(IconType.REFRESH, DataSetExplorerConstants.INSTANCE.loading(), ICON_COLOR_DEFAULT, true);
    }

    void showErrorIcon() {
        this.view.showSizePanelIcon(IconType.EXCLAMATION_TRIANGLE, DataSetExplorerConstants.INSTANCE.error(), ICON_COLOR_ERROR, false);
    }

    void showError(String uuid, ClientRuntimeError error) {
        this.errorEvent.fire((Object)new ErrorEvent((Object)this, error, uuid));
    }

    void showError(String uuid, Throwable throwable) {
        String msg = throwable != null ? throwable.getMessage() : DataSetExplorerConstants.INSTANCE.error();
        this.errorEvent.fire((Object)new ErrorEvent((Object)this, msg, uuid));
    }

    void showError(String uuid, String message) {
        this.errorEvent.fire((Object)new ErrorEvent((Object)this, message, uuid));
    }

    public static interface View
    extends UberView<DataSetSummary> {
        public View showStatusPanel(Boolean var1, Boolean var2, Boolean var3);

        public View showSizePanelIcon(IconType var1, String var2, String var3, boolean var4);

        public View showSizePanel(String var1, String var2);
    }
}

