/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.TableDisplayerSettingsBuilder;
import org.dashbuilder.displayer.client.DataSetEditHandler;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetDefPreviewTable
implements IsWidget {
    DataSetClientServices clientServices;
    DisplayerLocator displayerLocator;
    public View view;
    Displayer tableDisplayer;

    @Inject
    public DataSetDefPreviewTable(DisplayerLocator displayerLocator, DataSetClientServices clientServices, View view) {
        this.displayerLocator = displayerLocator;
        this.clientServices = clientServices;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show(DataSetDef dataSetDef, Collection<DataColumnDef> columns, DisplayerListener displayerListener) {
        this.clear();
        if (dataSetDef != null) {
            TableDisplayerSettingsBuilder tableDisplayerSettingsBuilder = (TableDisplayerSettingsBuilder)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset(dataSetDef.getUUID())).renderer("default")).titleVisible(false)).tablePageSize(6).tableOrderEnabled(true).filterOn(true, false, false);
            if (columns != null && !columns.isEmpty()) {
                for (DataColumnDef column : columns) {
                    tableDisplayerSettingsBuilder.column(column.getId());
                }
            }
            DisplayerSettings settings = tableDisplayerSettingsBuilder.buildSettings();
            DataSetDef editCloneWithoutCacheSettings = dataSetDef.clone();
            editCloneWithoutCacheSettings.setCacheEnabled(false);
            this.tableDisplayer = this.displayerLocator.lookupDisplayer(settings);
            this.tableDisplayer.setDataSetHandler((DataSetHandler)new DataSetEditHandler(this.clientServices, settings.getDataSetLookup(), editCloneWithoutCacheSettings));
            this.draw(displayerListener);
        }
    }

    void draw(DisplayerListener displayerListener) {
        this.tableDisplayer.addListener(new DisplayerListener[]{displayerListener});
        this.view.setDisplayer((IsWidget)this.tableDisplayer);
        this.tableDisplayer.draw();
    }

    public void clear() {
        this.tableDisplayer = null;
        this.view.clear();
    }

    public static interface View
    extends UberView<DataSetDefPreviewTable> {
        public View setDisplayer(IsWidget var1);

        public View clear();
    }
}

