/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.list.HorizImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.resources.bundles.DataSetClientResources;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetDefProviderTypeEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefProviderTypeEditor {
    HorizImageListEditor<DataSetProviderType> provider;
    public View view;
    DataSetProviderType[] CORE_TYPES = new DataSetProviderType[]{DataSetProviderType.BEAN, DataSetProviderType.CSV, DataSetProviderType.SQL, DataSetProviderType.ELASTICSEARCH};

    @Inject
    public DataSetDefProviderTypeEditor(HorizImageListEditor<DataSetProviderType> provider, View view) {
        this.provider = provider;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        Collection<ImageListEditor.Entry> entries = this.getDefaultEntries();
        this.provider.setEntries(entries);
        this.view.initWidgets((IsWidget)this.provider.view);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showErrors(List<EditorError> errors) {
    }

    public HorizImageListEditor<DataSetProviderType> provider() {
        return this.provider;
    }

    protected Collection<ImageListEditor.Entry> getDefaultEntries() {
        DataSetProviderType[] providerTypes = this.CORE_TYPES;
        ArrayList<ImageListEditor.Entry> entries = new ArrayList<ImageListEditor.Entry>(providerTypes.length);
        for (DataSetProviderType type : providerTypes) {
            String title = this.getTypeSelectorTitle(type);
            String text = this.getTypeSelectorText(type);
            SafeUri uri = this.getTypeSelectorImageUri(type);
            ImageListEditor.Entry entry = this.provider.newEntry((Object)type, uri, new SafeHtmlBuilder().appendEscaped(title).toSafeHtml(), new SafeHtmlBuilder().appendEscaped(text).toSafeHtml());
            entries.add(entry);
        }
        return entries;
    }

    String getTypeSelectorTitle(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.bean();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.csv();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.sql();
        }
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.elasticSearch();
        }
        return null;
    }

    String getTypeSelectorText(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.bean_description();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.csv_description();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.sql_description();
        }
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.elasticSearch_description();
        }
        return null;
    }

    SafeUri getTypeSelectorImageUri(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().javaIcon160().getSafeUri();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().csvIcon160().getSafeUri();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().sqlIcon160().getSafeUri();
        }
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)type)) {
            return DataSetClientResources.INSTANCE.images().elIcon160().getSafeUri();
        }
        return null;
    }

    public static interface View
    extends UberView<DataSetDefProviderTypeEditor> {
        public void initWidgets(IsWidget var1);
    }
}

