/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.Instance;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetExplorer;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetPanel;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetExplorerTest {
    @Mock
    DataSetExplorer.View view;
    @Mock
    DataSetPanel dataSetPanel;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    DataSetDef dataSetDefCustom;
    @Mock
    DataSetClientServices dataSetClientServices;
    Instance<DataSetPanel> panelInstances;
    private DataSetExplorer presenter;
    final List<DataSetDef> dataSetDefList = new ArrayList<DataSetDef>();

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.isPublic()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.dataSetDefCustom.getUUID()).thenReturn((Object)"uuid2");
        Mockito.when((Object)this.dataSetDefCustom.getName()).thenReturn((Object)"name2");
        Mockito.when((Object)this.dataSetDefCustom.isPublic()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSetDefCustom.getProvider()).thenReturn(() -> "CUSTOM");
        this.dataSetDefList.add(this.dataSetDef);
        this.dataSetDefList.add(this.dataSetDefCustom);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        Mockito.when((Object)this.view.asWidget()).thenReturn((Object)widget);
        this.panelInstances = new MockInstance();
        Mockito.when((Object)this.dataSetPanel.getDataSetDef()).thenReturn((Object)this.dataSetDef);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                RemoteCallback callback = (RemoteCallback)invocationOnMock.getArguments()[0];
                callback.callback(DataSetExplorerTest.this.dataSetDefList);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).getPublicDataSetDefs((RemoteCallback)Matchers.any(RemoteCallback.class));
        this.presenter = new DataSetExplorer(this.panelInstances, this.dataSetClientServices, this.view);
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
    }

    @Test
    public void testAsWidget() throws Exception {
        Util.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testShow() throws Exception {
        this.presenter.show();
        Util.assertEquals((Object)1, (Object)this.presenter.panels.size());
        Util.assertEquals((Object)this.dataSetPanel, this.presenter.panels.get(0));
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addPanel((DataSetPanel.View)Matchers.any(DataSetPanel.View.class));
        ((DataSetPanel)Mockito.verify((Object)this.dataSetPanel, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef, "dataSetsExplorerPanelGroup");
    }

    @Test
    public void testShowTwice() throws Exception {
        this.dataSetDefList.add(this.dataSetDef);
        this.presenter.show();
        Util.assertEquals((Object)1, (Object)this.presenter.panels.size());
        Util.assertEquals((Object)this.dataSetPanel, this.presenter.panels.get(0));
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addPanel((DataSetPanel.View)Matchers.any(DataSetPanel.View.class));
        ((DataSetPanel)Mockito.verify((Object)this.dataSetPanel, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef, "dataSetsExplorerPanelGroup");
    }

    @Test
    public void testOnDataSetDefRegisteredEvent() {
        DataSetDefRegisteredEvent event = (DataSetDefRegisteredEvent)Mockito.mock(DataSetDefRegisteredEvent.class);
        Mockito.when((Object)event.getDataSetDef()).thenReturn((Object)this.dataSetDef);
        this.presenter.onDataSetDefRegisteredEvent(event);
        Util.assertEquals((Object)1, (Object)this.presenter.panels.size());
        Util.assertEquals((Object)this.dataSetPanel, this.presenter.panels.get(0));
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addPanel((DataSetPanel.View)Matchers.any(DataSetPanel.View.class));
        ((DataSetPanel)Mockito.verify((Object)this.dataSetPanel, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef, "dataSetsExplorerPanelGroup");
    }

    @Test
    public void testOnDataSetDefModifiedEvent() {
        DataSetDefModifiedEvent event = (DataSetDefModifiedEvent)Mockito.mock(DataSetDefModifiedEvent.class);
        Mockito.when((Object)event.getOldDataSetDef()).thenReturn((Object)this.dataSetDef);
        Mockito.when((Object)event.getNewDataSetDef()).thenReturn((Object)this.dataSetDef);
        this.presenter.panels.add(this.dataSetPanel);
        this.presenter.onDataSetDefModifiedEvent(event);
        Util.assertEquals((Object)1, (Object)this.presenter.panels.size());
        Util.assertEquals((Object)this.dataSetPanel, this.presenter.panels.get(0));
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addPanel((DataSetPanel.View)Matchers.any(DataSetPanel.View.class));
        ((DataSetPanel)Mockito.verify((Object)this.dataSetPanel, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef, "dataSetsExplorerPanelGroup");
        ((DataSetPanel)Mockito.verify((Object)this.dataSetPanel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testOnDataSetDefRemovedEvent() {
        DataSetDef removedDataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)removedDataSetDef.getUUID()).thenReturn((Object)"removed");
        Mockito.when((Object)removedDataSetDef.getName()).thenReturn((Object)"removedDef");
        Mockito.when((Object)removedDataSetDef.isPublic()).thenReturn((Object)true);
        Mockito.when((Object)removedDataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        DataSetDefRemovedEvent event = (DataSetDefRemovedEvent)Mockito.mock(DataSetDefRemovedEvent.class);
        Mockito.when((Object)event.getDataSetDef()).thenReturn((Object)removedDataSetDef);
        this.presenter.onDataSetDefRemovedEvent(event);
        Util.assertEquals((Object)1, (Object)this.presenter.panels.size());
        Util.assertEquals((Object)this.dataSetPanel, this.presenter.panels.get(0));
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((DataSetExplorer.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addPanel((DataSetPanel.View)Matchers.any(DataSetPanel.View.class));
        ((DataSetPanel)Mockito.verify((Object)this.dataSetPanel, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef, "dataSetsExplorerPanelGroup");
    }

    private class MockInstance
    implements Instance<DataSetPanel> {
        private MockInstance() {
        }

        public Instance<DataSetPanel> select(Annotation ... annotations) {
            return null;
        }

        public <U extends DataSetPanel> Instance<U> select(Class<U> aClass, Annotation ... annotations) {
            return (Instance)DataSetExplorerTest.this.dataSetPanel;
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public boolean isAmbiguous() {
            return false;
        }

        public void destroy(DataSetPanel dataSetPanel) {
        }

        public Iterator<DataSetPanel> iterator() {
            return null;
        }

        public DataSetPanel get() {
            return DataSetExplorerTest.this.dataSetPanel;
        }
    }
}

