/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.attributes;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataset.client.resources.i18n.DateIntervalTypeConstants;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetDefRefreshIntervalEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefRefreshIntervalEditor {
    private static final DateIntervalType DEFAULT_INTERVAL_TYPE = DateIntervalType.HOUR;
    private static List<DateIntervalType> ALLOWED_TYPES = Arrays.asList(DateIntervalType.SECOND, DateIntervalType.MINUTE, DateIntervalType.HOUR, DateIntervalType.DAY, DateIntervalType.MONTH, DateIntervalType.YEAR);
    Event<ValueChangeEvent<String>> valueChangeEvent;
    public View view;

    @Inject
    public DataSetDefRefreshIntervalEditor(View view, Event<ValueChangeEvent<String>> valueChangeEvent) {
        this.view = view;
        this.valueChangeEvent = valueChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        for (DateIntervalType dateInterval : ALLOWED_TYPES) {
            String s = DateIntervalTypeConstants.INSTANCE.getString(dateInterval.name());
            this.view.addIntervalTypeItem(s);
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void addHelpContent(String title, String content, Placement placement) {
        this.view.addHelpContent(title, content, placement);
    }

    public void setEnabled(boolean isEnabled) {
        this.view.setEnabled(isEnabled);
    }

    public void setValue(String value) {
        double quantity = 1.0;
        int index = -1;
        if (value != null) {
            TimeAmount timeAmount = TimeAmount.parse((String)value);
            quantity = timeAmount.getQuantity();
            DateIntervalType dType = timeAmount.getType();
            index = this.getIntervalTypeIndex(dType);
        }
        this.view.setQuantity(quantity);
        this.view.setSelectedIntervalType(index > -1 ? index : this.getIntervalTypeIndex(DEFAULT_INTERVAL_TYPE));
    }

    public String getValue() {
        Double quantity = this.view.getQuantity();
        DateIntervalType type = this.getSelectedIntervalType();
        return new TimeAmount(quantity.longValue(), type).toString();
    }

    private DateIntervalType getSelectedIntervalType() {
        return ALLOWED_TYPES.get(this.view.getSelectedIntervalTypeIndex());
    }

    private int getIntervalTypeIndex(DateIntervalType type) {
        for (int i = 0; i < ALLOWED_TYPES.size(); ++i) {
            if (!ALLOWED_TYPES.get(i).equals((Object)type)) continue;
            return i;
        }
        return 0;
    }

    public static interface View
    extends UberView<DataSetDefRefreshIntervalEditor> {
        public View addHelpContent(String var1, String var2, Placement var3);

        public View addIntervalTypeItem(String var1);

        public View setSelectedIntervalType(int var1);

        public int getSelectedIntervalTypeIndex();

        public View setQuantity(double var1);

        public double getQuantity();

        public View setEnabled(boolean var1);
    }
}

