/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collection;
import org.dashbuilder.client.widgets.dataset.editor.column.ColumnTypeEditor;
import org.dashbuilder.common.client.editor.list.DropDownImageListEditor;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnTypeEditorTest {
    @Mock
    DropDownImageListEditor<ColumnType> columnType;
    @Mock
    Widget columnTypeWidget;
    private ColumnTypeEditor presenter;

    @Before
    public void setup() {
        this.presenter = (ColumnTypeEditor)Mockito.spy((Object)new ColumnTypeEditor(this.columnType));
        SafeUri uri = (SafeUri)Mockito.mock(SafeUri.class);
        ((ColumnTypeEditor)Mockito.doReturn((Object)uri).when((Object)this.presenter)).getImageUri((ColumnType)Matchers.any(ColumnType.class));
        Mockito.when((Object)this.columnType.asWidget()).thenReturn((Object)this.columnTypeWidget);
    }

    @Test
    public void testAsWidget() {
        Assert.assertEquals((Object)this.columnTypeWidget, (Object)this.presenter.asWidget());
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).setImageSize(Matchers.anyString(), Matchers.anyString());
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).setEntries((Collection)Matchers.any(Collection.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).isEditMode(Mockito.anyBoolean());
    }

    @Test
    public void testAddHelpContent() {
        Placement p = (Placement)Mockito.mock(Placement.class);
        this.presenter.addHelpContent("t1", "c1", p);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).addHelpContent("t1", "c1", p);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setImageSize(Matchers.anyString(), Matchers.anyString());
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setEntries((Collection)Matchers.any(Collection.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).isEditMode(Mockito.anyBoolean());
    }

    @Test
    public void testColumnType() {
        Assert.assertEquals(this.columnType, (Object)this.presenter.columnType());
    }

    @Test
    public void testEnableEditMode() {
        this.presenter.isEditMode(true);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).isEditMode(true);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setImageSize(Matchers.anyString(), Matchers.anyString());
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setEntries((Collection)Matchers.any(Collection.class));
    }

    @Test
    public void testDisableEditMode() {
        this.presenter.isEditMode(false);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setImageSize(Matchers.anyString(), Matchers.anyString());
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setEntries((Collection)Matchers.any(Collection.class));
    }

    @Test
    public void testSetValue() {
        DataColumnDef col1 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col1.getId()).thenReturn((Object)"col1");
        Mockito.when((Object)col1.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        this.presenter.setValue(col1);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).setEntries((Collection)Matchers.any(Collection.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).isEditMode(Mockito.anyBoolean());
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setImageSize(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testSetOriginalColumnType() {
        ColumnType type = (ColumnType)Mockito.mock(ColumnType.class);
        this.presenter.setOriginalColumnType(type);
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)1))).setEntries((Collection)Matchers.any(Collection.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).isEditMode(Mockito.anyBoolean());
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((DropDownImageListEditor)Mockito.verify(this.columnType, (VerificationMode)Mockito.times((int)0))).setImageSize(Matchers.anyString(), Matchers.anyString());
    }
}

