/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.event.EditDataSetEvent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetPanel;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetSummary;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetPanelTest {
    @Mock
    DataSetSummary dataSetSummary;
    @Mock
    EventSourceMock<EditDataSetEvent> editDataSetEvent;
    @Mock
    DataSetPanel.View view;
    @Mock
    DataSetDef dataSetDef;
    private DataSetPanel presenter;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        Mockito.when((Object)this.view.asWidget()).thenReturn((Object)widget);
        this.presenter = (DataSetPanel)Mockito.spy((Object)new DataSetPanel(this.dataSetSummary, this.editDataSetEvent, this.view));
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).configure((DataSetSummary.View)Matchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(Matchers.anyString(), Matchers.anyString(), (SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(Matchers.anyString(), (ClickHandler)Matchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testAsWidget() throws Exception {
        Util.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClose() throws Exception {
        this.presenter.close();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)Matchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(Matchers.anyString(), Matchers.anyString(), (SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(Matchers.anyString(), (ClickHandler)Matchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testDisable() throws Exception {
        this.presenter.disable();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)Matchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(Matchers.anyString(), Matchers.anyString(), (SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(Matchers.anyString(), (ClickHandler)Matchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disableActionButton();
    }

    @Test
    public void testShow() throws Exception {
        String iconTitle = "iconTitle";
        ((DataSetPanel)Mockito.doReturn((Object)"iconTitle").when((Object)this.presenter)).getTypeIconTitle(this.dataSetDef);
        SafeUri iconUri = (SafeUri)Mockito.mock(SafeUri.class);
        ((DataSetPanel)Mockito.doReturn((Object)iconUri).when((Object)this.presenter)).getTypeIconUri(this.dataSetDef);
        String parentPanelId = "parentPanel";
        this.presenter.show(this.dataSetDef, "parentPanel");
        Util.assertEquals((Object)this.dataSetDef, (Object)this.presenter.getDataSetDef());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)Matchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showHeader("uuid1", "parentPanel", iconUri, "iconTitle", "name1");
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(Matchers.anyString(), (ClickHandler)Matchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testOpen() throws Exception {
        this.presenter.def = this.dataSetDef;
        this.presenter.open();
        ((DataSetSummary)Mockito.verify((Object)this.dataSetSummary, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)Matchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(Matchers.anyString(), Matchers.anyString(), (SafeUri)Matchers.any(SafeUri.class), Matchers.anyString(), Matchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableActionButton(Matchers.anyString(), (ClickHandler)Matchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }
}

