/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefFilterEditor;
import org.dashbuilder.client.widgets.dataset.editor.column.DataSetDefColumnsEditor;
import org.dashbuilder.client.widgets.dataset.event.FilterChangedEvent;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DataSetDefColumnsFilterEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefColumnsFilterEditor {
    DataSetDefColumnsEditor columnsEditor;
    DataSetDefFilterEditor dataSetFilterEditor;
    public View view;

    @Inject
    public DataSetDefColumnsFilterEditor(DataSetDefColumnsEditor columnsEditor, DataSetDefFilterEditor dataSetFilterEditor, View view) {
        this.columnsEditor = columnsEditor;
        this.dataSetFilterEditor = dataSetFilterEditor;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets((IsWidget)this.columnsEditor.asWidget(), this.dataSetFilterEditor.view);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setMaxHeight(String maxHeight) {
        this.view.setMaxHeight(maxHeight);
    }

    public org.dashbuilder.dataset.client.editor.DataSetDefColumnsEditor columnListEditor() {
        return this.columnsEditor;
    }

    public org.dashbuilder.dataset.client.editor.DataSetDefFilterEditor dataSetFilter() {
        return this.dataSetFilterEditor;
    }

    public void setAcceptableValues(List<DataColumnDef> acceptableValues) {
        this.columnsEditor.setAcceptableValues(acceptableValues);
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(DataSetDef value) {
        if (value != null && value.getDataSetFilter() != null) {
            this.updateColumnsRestrictedByFilter(null, value.getDataSetFilter());
        }
    }

    public void setDelegate(EditorDelegate<DataSetDef> delegate) {
    }

    private void updateColumnsRestrictedByFilter(DataSetFilter oldFilter, DataSetFilter f) {
        List<String> oldFilterColumns = this.getFilterColumnIds(oldFilter);
        List<String> newFilterColumns = this.getFilterColumnIds(f);
        if (!oldFilterColumns.isEmpty()) {
            for (String oldFilterColumn : oldFilterColumns) {
                boolean isRemoved = !newFilterColumns.contains(oldFilterColumn);
                if (!isRemoved) continue;
                this.columnsEditor.onValueUnRestricted(oldFilterColumn);
            }
        }
        if (!newFilterColumns.isEmpty()) {
            for (String newFilterColumn : newFilterColumns) {
                this.columnsEditor.onValueRestricted(newFilterColumn);
            }
        }
    }

    private List<String> getFilterColumnIds(DataSetFilter filter) {
        List columnFilters;
        ArrayList<String> result = new ArrayList<String>();
        if (filter != null && (columnFilters = filter.getColumnFilterList()) != null && !columnFilters.isEmpty()) {
            for (ColumnFilter cFilter : columnFilters) {
                result.add(cFilter.getColumnId());
            }
        }
        return result;
    }

    void onFilterChangedEvent(@Observes FilterChangedEvent filterChangedEvent) {
        PortablePreconditions.checkNotNull((String)"filterChangedEvent", (Object)((Object)filterChangedEvent));
        if (filterChangedEvent.getContext().equals(this.dataSetFilterEditor)) {
            DataSetFilter old = filterChangedEvent.getOldFilter();
            DataSetFilter f = filterChangedEvent.getFilter();
            this.updateColumnsRestrictedByFilter(old, f);
        }
    }

    public static interface View
    extends UberView<DataSetDefColumnsFilterEditor> {
        public void initWidgets(IsWidget var1, DataSetDefFilterEditor.View var2);

        public void setMaxHeight(String var1);
    }
}

