/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.attributes;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefCacheAttributesEditorView;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.ToggleSwitchEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataset.def.DataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DataSetDefBackendCacheAttributesEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefBackendCacheAttributesEditor {
    ToggleSwitchEditor cacheEnabled;
    ValueBoxEditor<Integer> cacheMaxRows;
    public DataSetDefCacheAttributesEditorView view;
    final DataSetDefCacheAttributesEditorView.ViewCallback viewCallback = new DataSetDefCacheAttributesEditorView.ViewCallback(){

        @Override
        public void onValueChange(Double value) {
            DataSetDefBackendCacheAttributesEditor.this.cacheMaxRows.setValue((Object)(value != null ? value.intValue() : 100));
        }
    };

    @Inject
    public DataSetDefBackendCacheAttributesEditor(ToggleSwitchEditor cacheEnabled, ValueBoxEditor<Integer> cacheMaxRows, DataSetDefCacheAttributesEditorView view) {
        this.cacheEnabled = cacheEnabled;
        this.cacheMaxRows = cacheMaxRows;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this.viewCallback);
        this.view.init(DataSetEditorConstants.INSTANCE.backendCache(), DataSetEditorConstants.INSTANCE.rows(), (IsWidget)this.cacheEnabled.asWidget(), this.cacheMaxRows.view);
        this.cacheMaxRows.addHelpContent(DataSetEditorConstants.INSTANCE.attributeMaxRows(), DataSetEditorConstants.INSTANCE.attributeMaxRows_description(), Placement.BOTTOM);
    }

    public void setRange(Double min, Double max) {
        this.view.setRange(min, max);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public ToggleSwitchEditor cacheEnabled() {
        return this.cacheEnabled;
    }

    public ValueBoxEditor<Integer> cacheMaxRows() {
        return this.cacheMaxRows;
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(DataSetDef value) {
        Double _value = value != null ? (double)value.getCacheMaxRows().intValue() : 100.0;
        if (value != null && value.isCacheEnabled()) {
            this.enable();
        } else {
            this.disable();
        }
        this.view.setValue(_value);
    }

    public void setDelegate(EditorDelegate<DataSetDef> delegate) {
    }

    void enable() {
        this.view.setEnabled(true);
    }

    void disable() {
        this.view.setEnabled(false);
    }

    void onEnabledChangedEvent(@Observes ValueChangeEvent<Boolean> valueChangeEvent) {
        PortablePreconditions.checkNotNull((String)"valueChangeEvent", valueChangeEvent);
        if (valueChangeEvent.getContext().equals(this.cacheEnabled)) {
            if (((Boolean)valueChangeEvent.getValue()).booleanValue()) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }
}

