/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.create;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.SQLDataSetDefAttributesDriver;
import org.dashbuilder.client.widgets.dataset.editor.sql.SQLDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.SQLDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.validations.dataset.SQLDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class SQLDataSetBasicAttributesWorkflowTest
extends AbstractDataSetWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    SQLDataSetDef dataSetDef;
    @Mock
    DataSetDefBasicAttributesEditor basicAttributesEditor;
    @Mock
    SQLDataSetDefAttributesEditor sqlDataSetDefAttributesEditor;
    @Mock
    DataSetEditorWorkflow.View view;
    private SQLDataSetBasicAttributesWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.presenter = new SQLDataSetBasicAttributesWorkflow(this.clientServices, this.validatorProvider, this.beanManager, this.basicAttributesEditor, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(SQLDataSetDefAttributesDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(SQLDataSetDefAttributesEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidateUsingQuery() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.sqlDataSetDefAttributesEditor;
        Mockito.when((Object)this.sqlDataSetDefAttributesEditor.isUsingQuery()).thenReturn((Object)true);
        this.presenter.validate();
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validateCustomAttributes((SQLDataSetDef)Matchers.any(SQLDataSetDef.class), new Object[]{Mockito.eq((boolean)true)});
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validate((SQLDataSetDef)Matchers.any(SQLDataSetDef.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), new Object[0]);
    }

    @Test
    public void testValidateUsingTable() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.sqlDataSetDefAttributesEditor;
        Mockito.when((Object)this.sqlDataSetDefAttributesEditor.isUsingQuery()).thenReturn((Object)false);
        this.presenter.validate();
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validateCustomAttributes((SQLDataSetDef)Matchers.any(SQLDataSetDef.class), new Object[]{Mockito.eq((boolean)false)});
        ((SQLDataSetDefValidator)Mockito.verify((Object)this.sqlDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validate((SQLDataSetDef)Matchers.any(SQLDataSetDef.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), new Object[0]);
    }

    @Test
    public void testFlushDriverUsingQuery() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.sqlDataSetDefAttributesEditor;
        Mockito.when((Object)this.sqlDataSetDefAttributesEditor.isUsingQuery()).thenReturn((Object)true);
        this.presenter.afterFlush();
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setDbTable(null);
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setDbSQL(null);
    }

    @Test
    public void testFlushDriverUsingTable() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.sqlDataSetDefAttributesEditor;
        Mockito.when((Object)this.sqlDataSetDefAttributesEditor.isUsingQuery()).thenReturn((Object)false);
        this.presenter.afterFlush();
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setDbSQL(null);
        ((SQLDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setDbTable(null);
    }
}

