/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.dashbuilder.client.widgets.common.CustomDataSetProviderType;
import org.dashbuilder.client.widgets.common.DataSetEditorPlugin;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefProviderTypeEditor;
import org.dashbuilder.client.widgets.dataset.event.DataSetDefCreationRequestEvent;
import org.dashbuilder.common.client.editor.list.HorizImageListEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefProviderTypeEditorTest {
    @Mock
    HorizImageListEditor<DataSetProviderType> provider;
    @Mock
    DataSetDefProviderTypeEditor.View view;
    @Mock
    EventSourceMock<DataSetDefCreationRequestEvent> createEvent;
    private DataSetDefProviderTypeEditor tested;
    @Mock
    ManagedInstance<DataSetEditorPlugin> dataSetEditorPlugin;
    @Mock
    DataSetEditorPlugin pluginEditor;

    @Before
    public void setup() {
        Mockito.when((Object)this.dataSetEditorPlugin.isUnsatisfied()).thenReturn((Object)true);
        this.tested = (DataSetDefProviderTypeEditor)Mockito.spy((Object)new DataSetDefProviderTypeEditor(this.provider, this.createEvent, this.view, this.dataSetEditorPlugin));
        String typeTitle = "typeTitle";
        ((DataSetDefProviderTypeEditor)Mockito.doReturn((Object)"typeTitle").when((Object)this.tested)).getTypeSelectorTitle((DataSetProviderType)Matchers.any(DataSetProviderType.class));
        String typeText = "typeText";
        ((DataSetDefProviderTypeEditor)Mockito.doReturn((Object)"typeText").when((Object)this.tested)).getTypeSelectorText((DataSetProviderType)Matchers.any(DataSetProviderType.class));
        SafeUri imageUri = (SafeUri)Mockito.mock(SafeUri.class);
        ((DataSetDefProviderTypeEditor)Mockito.doReturn((Object)imageUri).when((Object)this.tested)).getTypeSelectorImageUri((DataSetProviderType)Matchers.any(DataSetProviderType.class));
    }

    @Test
    public void testInit() throws Exception {
        this.tested.init();
        ((DataSetDefProviderTypeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((DataSetDefProviderTypeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((IsWidget)Matchers.any(IsWidget.class));
        ArgumentCaptor actualEntriesCaptor = ArgumentCaptor.forClass(Collection.class);
        ((HorizImageListEditor)Mockito.verify(this.provider, (VerificationMode)Mockito.times((int)1))).setEntries((Collection)actualEntriesCaptor.capture());
        Collection actualEntries = (Collection)actualEntriesCaptor.getValue();
        TestCase.assertEquals((int)4, (int)actualEntries.size());
    }

    @Test
    public void testProviderInstance() throws Exception {
        TestCase.assertEquals(this.provider, (Object)this.tested.provider());
    }

    @Test
    public void testProviderSelected() throws Exception {
        this.tested.onItemClicked(new ValueChangeEvent(this.provider, null, (Object)DataSetProviderType.BEAN));
        ((EventSourceMock)Mockito.verify(this.createEvent)).fire(Matchers.any());
    }

    @Test
    public void testInitWithEditorPlugin() throws Exception {
        Mockito.when((Object)this.pluginEditor.getProviderType()).thenReturn((Object)new CustomDataSetProviderType());
        Mockito.when((Object)this.pluginEditor.getTypeSelectorTitle()).thenReturn((Object)"Custom");
        Mockito.when((Object)this.pluginEditor.getTypeSelectorText()).thenReturn((Object)"CustomText");
        Mockito.when((Object)this.pluginEditor.getTypeSelectorImageUri()).thenReturn(Mockito.mock(SafeUri.class));
        Mockito.when((Object)this.dataSetEditorPlugin.isUnsatisfied()).thenReturn((Object)false);
        Mockito.when((Object)this.dataSetEditorPlugin.iterator()).thenReturn(Arrays.asList(this.pluginEditor).iterator(), (Object[])new Iterator[]{Arrays.asList(this.pluginEditor).iterator()});
        this.tested.init();
        ((DataSetDefProviderTypeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((DataSetDefProviderTypeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((IsWidget)Matchers.any(IsWidget.class));
        ArgumentCaptor actualEntriesCaptor = ArgumentCaptor.forClass(Collection.class);
        ((HorizImageListEditor)Mockito.verify(this.provider, (VerificationMode)Mockito.times((int)1))).setEntries((Collection)actualEntriesCaptor.capture());
        Collection actualEntries = (Collection)actualEntriesCaptor.getValue();
        TestCase.assertEquals((int)5, (int)actualEntries.size());
        ((DataSetEditorPlugin)Mockito.verify((Object)this.pluginEditor, (VerificationMode)Mockito.times((int)1))).getTypeSelectorImageUri();
        ((DataSetEditorPlugin)Mockito.verify((Object)this.pluginEditor, (VerificationMode)Mockito.times((int)1))).getTypeSelectorTitle();
        ((DataSetEditorPlugin)Mockito.verify((Object)this.pluginEditor, (VerificationMode)Mockito.times((int)1))).getTypeSelectorText();
    }
}

