/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.bean.BeanDataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.BeanDataSetDefDriver;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.BeanDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.validations.dataset.BeanDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class BeanDataSetEditWorkflowTest
extends AbstractDataSetWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DataSet dataSet;
    @Mock
    DataSetEditorWorkflow.View view;
    @Mock
    BeanDataSetEditor beanEditor;
    @Mock
    BeanDataSetDef dataSetDef;
    @Mock
    DataSetDefRefreshAttributesEditor refreshEditor;
    private BeanDataSetEditWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.presenter = new BeanDataSetEditWorkflow(this.clientServices, this.validatorProvider, this.beanManager, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.beanEditor.refreshEditor()).thenReturn((Object)this.refreshEditor);
        Mockito.when((Object)this.refreshEditor.isRefreshEnabled()).thenReturn((Object)true);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(BeanDataSetDefDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(BeanDataSetEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidate() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.validate(true, true, true);
        ((BeanDataSetDefValidator)Mockito.verify((Object)this.beanDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validate(this.dataSetDef, true, true, true, new Object[0]);
        ((BeanDataSetDefValidator)Mockito.verify((Object)this.beanDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validateCustomAttributes(this.dataSetDef, new Object[]{true});
    }
}

