/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetSummary;
import org.dashbuilder.client.widgets.resources.i18n.DataSetExplorerConstants;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;

@Dependent
public class DataSetSummaryView
extends Composite
implements DataSetSummary.View {
    private static DataSetSummaryViewBinder uiBinder = (DataSetSummaryViewBinder)GWT.create(DataSetSummaryViewBinder.class);
    @UiField
    DataSetSummaryViewStyle style;
    @UiField
    Span backendStatus;
    @UiField
    Icon backendStatusIcon;
    @UiField
    Span pushStatus;
    @UiField
    Icon pushEnabledIcon;
    @UiField
    Span refreshStatus;
    @UiField
    Icon refreshEnabledIcon;
    @UiField
    Icon statusIcon;
    @UiField
    HTML estimatedSizeText;
    @UiField
    HTML estimatedRowsText;
    private DataSetSummary presenter;

    public DataSetSummaryView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(DataSetSummary presenter) {
        this.presenter = presenter;
    }

    @Override
    public DataSetSummary.View showStatusPanel(Boolean backendCacheStatus, Boolean pushEnabled, Boolean _refreshStatus) {
        if (backendCacheStatus != null) {
            this.configureStatusIcon(this.backendStatusIcon, backendCacheStatus);
            this.backendStatus.setVisible(true);
        } else {
            this.backendStatus.setVisible(false);
        }
        if (pushEnabled != null) {
            this.configureStatusIcon(this.pushEnabledIcon, pushEnabled);
            this.pushStatus.setVisible(true);
        } else {
            this.pushStatus.setVisible(false);
        }
        if (_refreshStatus != null) {
            this.configureStatusIcon(this.refreshEnabledIcon, _refreshStatus);
            this.refreshStatus.setVisible(true);
        } else {
            this.refreshStatus.setVisible(false);
        }
        return this;
    }

    private void configureStatusIcon(Icon icon, boolean value) {
        String t = value ? DataSetExplorerConstants.INSTANCE.enabled() : DataSetExplorerConstants.INSTANCE.disabled();
        icon.setType(value ? IconType.CHECK : IconType.REMOVE);
        icon.setTitle(t);
    }

    @Override
    public DataSetSummary.View showSizePanelIcon(IconType type, String title, String color, boolean spin) {
        this.statusIcon.setType(type);
        this.statusIcon.setTitle(title != null ? title : "");
        this.statusIcon.setColor(color != null ? color : "black");
        this.statusIcon.setSpin(spin);
        this.statusIcon.setVisible(true);
        return this;
    }

    @Override
    public DataSetSummary.View showSizePanel(String backendSizeRow, String clientSizeKb) {
        this.estimatedRowsText.setText(backendSizeRow);
        this.estimatedSizeText.setText(clientSizeKb);
        this.statusIcon.setVisible(false);
        return this;
    }

    static interface DataSetSummaryViewStyle
    extends CssResource {
    }

    static interface DataSetSummaryViewBinder
    extends UiBinder<Row, DataSetSummaryView> {
    }
}

