/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.create;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.csv.CSVDataSetDefAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.CSVDataSetDefAttributesDriver;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.CSVDataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.validations.dataset.CSVDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class CSVDataSetBasicAttributesWorkflowTest
extends AbstractDataSetWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    CSVDataSetDef dataSetDef;
    @Mock
    DataSetDefBasicAttributesEditor basicAttributesEditor;
    @Mock
    CSVDataSetDefAttributesEditor csvDataSetDefAttributesEditor;
    @Mock
    DataSetEditorWorkflow.View view;
    private CSVDataSetBasicAttributesWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.presenter = new CSVDataSetBasicAttributesWorkflow(this.clientServices, this.validatorProvider, this.beanManager, this.basicAttributesEditor, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.CSV);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(CSVDataSetDefAttributesDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(CSVDataSetDefAttributesEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidateUsingFilePath() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.csvDataSetDefAttributesEditor;
        Mockito.when((Object)this.csvDataSetDefAttributesEditor.isUsingFilePath()).thenReturn((Object)true);
        this.presenter.validate();
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validateCustomAttributes(this.dataSetDef, new Object[]{true});
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validate((CSVDataSetDef)Matchers.any(CSVDataSetDef.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), new Object[0]);
    }

    @Test
    public void testValidateUsingFileUrl() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.csvDataSetDefAttributesEditor;
        Mockito.when((Object)this.csvDataSetDefAttributesEditor.isUsingFilePath()).thenReturn((Object)false);
        this.presenter.validate();
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validateCustomAttributes(this.dataSetDef, new Object[]{false});
        ((CSVDataSetDefValidator)Mockito.verify((Object)this.csvDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validate((CSVDataSetDef)Matchers.any(CSVDataSetDef.class), Matchers.anyBoolean(), Matchers.anyBoolean(), Matchers.anyBoolean(), new Object[0]);
    }

    @Test
    public void testFlushDriverUsingFilePath() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.csvDataSetDefAttributesEditor;
        Mockito.when((Object)this.csvDataSetDefAttributesEditor.isUsingFilePath()).thenReturn((Object)true);
        this.presenter.afterFlush();
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setFileURL(null);
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setFilePath(null);
    }

    @Test
    public void testFlushDriverUsingFileUrl() throws Exception {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.editor = this.csvDataSetDefAttributesEditor;
        Mockito.when((Object)this.csvDataSetDefAttributesEditor.isUsingFilePath()).thenReturn((Object)false);
        this.presenter.afterFlush();
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setFilePath(null);
        ((CSVDataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setFileURL(null);
    }
}

