/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefFilterEditor;
import org.dashbuilder.client.widgets.dataset.event.FilterChangedEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.client.events.DataSetFilterChangedEvent;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefFilterEditorTest {
    @Mock
    EventSourceMock<FilterChangedEvent> filterChangedEvent;
    @Mock
    DataSetDefFilterEditor.View view;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    DataSetFilterEditor dataSetFilterEditor;
    @Mock
    DataSetMetadata dataSetMetadata = (DataSetMetadata)Mockito.mock(DataSetMetadata.class);
    @Mock
    DataSetFilter filter1 = (DataSetFilter)Mockito.mock(DataSetFilter.class);
    @Mock
    DataSetFilter filter2 = (DataSetFilter)Mockito.mock(DataSetFilter.class);
    private DataSetDefFilterEditor tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.filter1.cloneInstance()).thenReturn((Object)this.filter2);
        this.tested = new DataSetDefFilterEditor(this.view, this.dataSetFilterEditor, this.filterChangedEvent);
    }

    @Test
    public void testInit() throws Exception {
        ((DataSetDefFilterEditor.View)Mockito.verify((Object)this.view)).init((Object)this.tested);
    }

    @Test
    public void testInitFilterEditor() throws Exception {
        this.tested.value = this.filter1;
        this.tested.init(this.dataSetMetadata);
        ((DataSetDefFilterEditor.View)Mockito.verify((Object)this.view)).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetFilterEditor)Mockito.verify((Object)this.dataSetFilterEditor)).init((DataSetFilter)Mockito.eq((Object)this.filter2), (DataSetMetadata)Mockito.eq((Object)this.dataSetMetadata));
    }

    @Test
    public void testSetValue() throws Exception {
        this.tested.setValue(this.filter1);
        Util.assertEquals((Object)this.filter2, (Object)this.tested.value);
        ((DataSetDefFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetFilterEditor)Mockito.verify((Object)this.dataSetFilterEditor, (VerificationMode)Mockito.never())).init((DataSetFilter)Matchers.any(DataSetFilter.class), (DataSetMetadata)Matchers.any(DataSetMetadata.class));
    }

    @Test
    public void testOnValueChanged() throws Exception {
        DataSetFilter filter3 = (DataSetFilter)Mockito.mock(DataSetFilter.class);
        Mockito.when((Object)this.filter2.cloneInstance()).thenReturn((Object)filter3);
        this.tested.value = this.filter1;
        this.tested.onValueChanged(new DataSetFilterChangedEvent(this.filter2));
        Util.assertEquals((Object)filter3, (Object)this.tested.value);
        ((DataSetDefFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setWidget((IsWidget)Matchers.any(IsWidget.class));
        ((DataSetFilterEditor)Mockito.verify((Object)this.dataSetFilterEditor, (VerificationMode)Mockito.never())).init((DataSetFilter)Matchers.any(DataSetFilter.class), (DataSetMetadata)Matchers.any(DataSetMetadata.class));
        ((EventSourceMock)Mockito.verify(this.filterChangedEvent)).fire(Matchers.any(FilterChangedEvent.class));
    }
}

