/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.driver.ElasticSearchDataSetDefDriver;
import org.dashbuilder.client.widgets.dataset.editor.elasticsearch.ElasticSearchDataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.ElasticSearchDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.validations.dataset.ElasticSearchDataSetDefValidator;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ElasticSearchDataSetEditWorkflowTest
extends AbstractDataSetWorkflowTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DataSet dataSet;
    @Mock
    DataSetEditorWorkflow.View view;
    @Mock
    ElasticSearchDataSetEditor elasticSearchEditor;
    @Mock
    ElasticSearchDataSetDef dataSetDef;
    @Mock
    DataSetDefRefreshAttributesEditor refreshEditor;
    private ElasticSearchDataSetEditWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.presenter = new ElasticSearchDataSetEditWorkflow(this.clientServices, this.validatorProvider, this.beanManager, this.saveRequestEvent, this.testDataSetEvent, this.cancelRequestEvent, this.view);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.ELASTICSEARCH);
        Mockito.when((Object)this.elasticSearchEditor.refreshEditor()).thenReturn((Object)this.refreshEditor);
        Mockito.when((Object)this.refreshEditor.isRefreshEnabled()).thenReturn((Object)true);
    }

    @Test
    public void testGetDriverClass() {
        Assert.assertEquals(ElasticSearchDataSetDefDriver.class, (Object)this.presenter.getDriverClass());
    }

    @Test
    public void testGetEditorClass() {
        Assert.assertEquals(ElasticSearchDataSetEditor.class, (Object)this.presenter.getEditorClass());
    }

    @Test
    public void testValidate() {
        this.presenter._setDataSetDef((DataSetDef)this.dataSetDef);
        this.presenter.validate(true, true, true);
        ((ElasticSearchDataSetDefValidator)Mockito.verify((Object)this.elasticSearchDataSetDefValidator, (VerificationMode)Mockito.times((int)1))).validate(this.dataSetDef, true, true, true, new Object[0]);
        ((ElasticSearchDataSetDefValidator)Mockito.verify((Object)this.elasticSearchDataSetDefValidator, (VerificationMode)Mockito.times((int)0))).validateCustomAttributes(this.dataSetDef, new Object[]{true});
    }
}

