/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.column.ColumnListEditor;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;

@Dependent
public class DataSetDefColumnsEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.DataSetDefColumnsEditor {
    ColumnListEditor columnListEditor;
    List<DataColumnDef> acceptableValues;

    @Inject
    public DataSetDefColumnsEditor(ColumnListEditor columnListEditor) {
        this.columnListEditor = columnListEditor;
    }

    public Widget asWidget() {
        return this.columnListEditor.asWidget();
    }

    public ColumnListEditor columns() {
        return this.columnListEditor;
    }

    public void setAcceptableValues(List<DataColumnDef> acceptableValues) {
        this.acceptableValues = acceptableValues;
        this.columnListEditor.setAcceptableValues(acceptableValues);
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(DataSetDef value) {
        this.checkAvailableColumns();
        if (value != null && value.isAllColumnsEnabled()) {
            ArrayList<DataColumnDef> columns = new ArrayList<DataColumnDef>(this.acceptableValues.size());
            for (DataColumnDef columnDef : this.acceptableValues) {
                columns.add(columnDef.clone());
            }
            value.setColumns(columns);
            value.setAllColumnsEnabled(false);
        }
        this.columnListEditor.setProviderType(value != null ? value.getProvider() : null);
    }

    public void setDelegate(EditorDelegate<DataSetDef> delegate) {
    }

    private void checkAvailableColumns() {
        if (this.acceptableValues == null) {
            throw new IllegalArgumentException("Must call setAcceptableValues() before setting the data set definition columns to edit.");
        }
    }

    public void onValueRestricted(String value) {
        this.columnListEditor.onValueRestricted(value);
    }

    public void onValueUnRestricted(String value) {
        this.columnListEditor.onValueUnRestricted(value);
    }
}

