/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefColumnsFilterEditor;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefFilterEditor;
import org.dashbuilder.client.widgets.dataset.editor.column.DataSetDefColumnsEditor;
import org.dashbuilder.client.widgets.dataset.event.FilterChangedEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefColumnsFilterEditorTest {
    @Mock
    DataSetDefColumnsEditor columnsEditor;
    @Mock
    DataSetDefFilterEditor dataSetFilterEditor;
    @Mock
    DataSetDefColumnsFilterEditor.View view;
    @Mock
    DataSetDef dataSetDef;
    private DataSetDefColumnsFilterEditor tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        this.tested = new DataSetDefColumnsFilterEditor(this.columnsEditor, this.dataSetFilterEditor, this.view);
    }

    @Test
    public void testInit() throws Exception {
        this.tested.init();
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.tested);
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((IsWidget)ArgumentMatchers.any(), (DataSetDefFilterEditor.View)ArgumentMatchers.any());
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setMaxHeight(Mockito.anyString());
    }

    @Test
    public void testSetMaxHeight() throws Exception {
        String maxH = "100px";
        this.tested.setMaxHeight("100px");
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefFilterEditor.View)ArgumentMatchers.any(DataSetDefFilterEditor.View.class));
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setMaxHeight("100px");
    }

    @Test
    public void testColumnListEditor() throws Exception {
        Util.assertEquals((Object)this.columnsEditor, (Object)this.tested.columnListEditor());
    }

    @Test
    public void testDataSetFilterEditor() throws Exception {
        Util.assertEquals((Object)this.dataSetFilterEditor, (Object)this.tested.dataSetFilter());
    }

    @Test
    public void testSetAcceptableValues() throws Exception {
        List l = (List)Mockito.mock(List.class);
        this.tested.setAcceptableValues(l);
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)1))).setAcceptableValues(l);
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefFilterEditor.View)ArgumentMatchers.any(DataSetDefFilterEditor.View.class));
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setMaxHeight(Mockito.anyString());
    }

    @Test
    public void testSetValue() throws Exception {
        DataSetFilter newFilter = (DataSetFilter)Mockito.mock(DataSetFilter.class);
        List<ColumnFilter> createColumnFilters = this.createColumnFilters("col1", "col2");
        Mockito.when((Object)newFilter.getColumnFilterList()).thenReturn(createColumnFilters);
        Mockito.when((Object)this.dataSetDef.getDataSetFilter()).thenReturn((Object)newFilter);
        this.tested.setValue(this.dataSetDef);
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)1))).onValueRestricted("col1");
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)1))).onValueRestricted("col2");
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)0))).onValueUnRestricted(Mockito.anyString());
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefFilterEditor.View)ArgumentMatchers.any(DataSetDefFilterEditor.View.class));
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setMaxHeight(Mockito.anyString());
    }

    @Test
    public void testOnFilterChangedEvent() throws Exception {
        DataSetFilter oldFilter = (DataSetFilter)Mockito.mock(DataSetFilter.class);
        List<ColumnFilter> oldCreateColumnFilters = this.createColumnFilters("col1", "col2", "col3");
        Mockito.when((Object)oldFilter.getColumnFilterList()).thenReturn(oldCreateColumnFilters);
        DataSetFilter newFilter = (DataSetFilter)Mockito.mock(DataSetFilter.class);
        List<ColumnFilter> createColumnFilters = this.createColumnFilters("col2");
        Mockito.when((Object)newFilter.getColumnFilterList()).thenReturn(createColumnFilters);
        Mockito.when((Object)this.dataSetDef.getDataSetFilter()).thenReturn((Object)newFilter);
        FilterChangedEvent filterChangedEvent = (FilterChangedEvent)Mockito.mock(FilterChangedEvent.class);
        Mockito.when((Object)filterChangedEvent.getContext()).thenReturn((Object)this.dataSetFilterEditor);
        Mockito.when((Object)filterChangedEvent.getOldFilter()).thenReturn((Object)oldFilter);
        Mockito.when((Object)filterChangedEvent.getFilter()).thenReturn((Object)newFilter);
        this.tested.onFilterChangedEvent(filterChangedEvent);
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)1))).onValueRestricted("col2");
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)1))).onValueUnRestricted("col1");
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)1))).onValueUnRestricted("col3");
        ((DataSetDefColumnsEditor)Mockito.verify((Object)this.columnsEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.tested);
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefFilterEditor.View)ArgumentMatchers.any(DataSetDefFilterEditor.View.class));
        ((DataSetDefColumnsFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setMaxHeight(Mockito.anyString());
    }

    private List<ColumnFilter> createColumnFilters(String ... columns) {
        ArrayList<ColumnFilter> result = new ArrayList<ColumnFilter>();
        for (String column : columns) {
            ColumnFilter cf = (ColumnFilter)Mockito.mock(ColumnFilter.class);
            Mockito.when((Object)cf.getColumnId()).thenReturn((Object)column);
            result.add(cf);
        }
        return result;
    }
}

