/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dashbuilder.client.widgets.common.LoadingBox;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefColumnsFilterEditor;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefFilterEditor;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefPreviewTable;
import org.dashbuilder.client.widgets.dataset.editor.DataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBackendCacheAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefCacheAttributesEditorView;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefClientCacheAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.client.widgets.dataset.event.ColumnsChangedEvent;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.dataset.event.FilterChangedEvent;
import org.dashbuilder.client.widgets.dataset.event.TabChangedEvent;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.ColumnListEditor;
import org.dashbuilder.dataset.client.editor.DataSetDefColumnsEditor;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetEditorTest {
    @Mock
    protected DataSetDefBasicAttributesEditor basicAttributesEditor;
    @Mock
    protected IsWidget providerAttributesEditorView;
    @Mock
    protected DataSetDefColumnsFilterEditor columnsAndFilterEditor;
    @Mock
    protected DataSetDefPreviewTable previewTable;
    @Mock
    protected DataSetDefBackendCacheAttributesEditor backendCacheAttributesEditor;
    @Mock
    protected DataSetDefClientCacheAttributesEditor clientCacheAttributesEditor;
    @Mock
    protected DataSetDefRefreshAttributesEditor refreshEditor;
    @Mock
    protected DataSetClientServices clientServices;
    @Mock
    protected LoadingBox loadingBox;
    @Mock
    protected EventSourceMock<ErrorEvent> errorEvent;
    @Mock
    protected EventSourceMock<TabChangedEvent> tabChangedEvent;
    @Mock
    protected DataSetEditor.View view;
    @Mock
    protected DataSetDefFilterEditor filterEditor;
    @Mock
    protected DataSetDefColumnsEditor columnsEditor;
    @Mock
    protected ColumnListEditor columnListEditor;
    @Mock
    protected DataSetDef dataSetDef;
    private DataSetEditor<DataSetDef> presenter;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        IsWidget attributesEditor = (IsWidget)Mockito.mock(IsWidget.class);
        this.presenter = new DataSetEditor<DataSetDef>(this.basicAttributesEditor, attributesEditor, this.columnsAndFilterEditor, this.previewTable, this.backendCacheAttributesEditor, this.clientCacheAttributesEditor, this.refreshEditor, this.clientServices, this.loadingBox, this.errorEvent, this.tabChangedEvent, this.view){

            public void init() {
                super.init();
            }
        };
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.columnsAndFilterEditor.dataSetFilter()).thenReturn((Object)this.filterEditor);
        Mockito.when((Object)this.columnsAndFilterEditor.columnListEditor()).thenReturn((Object)this.columnsEditor);
        Mockito.when((Object)this.columnsEditor.columns()).thenReturn((Object)this.columnListEditor);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init(this.presenter);
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((DataSetDefBasicAttributesEditor.View)ArgumentMatchers.any(), (IsWidget)ArgumentMatchers.any(), (DataSetDefColumnsFilterEditor.View)ArgumentMatchers.any(), (DataSetDefPreviewTable.View)ArgumentMatchers.any(), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(), (DataSetDefRefreshAttributesEditor.View)ArgumentMatchers.any());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addConfigurationTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addPreviewTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addAdvancedTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetDefColumnsFilterEditor)Mockito.verify((Object)this.columnsAndFilterEditor, (VerificationMode)Mockito.times((int)1))).setMaxHeight(ArgumentMatchers.anyString());
        ((DataSetDefBackendCacheAttributesEditor)Mockito.verify((Object)this.backendCacheAttributesEditor, (VerificationMode)Mockito.times((int)1))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefClientCacheAttributesEditor)Mockito.verify((Object)this.clientCacheAttributesEditor, (VerificationMode)Mockito.times((int)1))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).openColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).closeColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showErrorNotification((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearErrorNotification();
    }

    @Test
    public void testShowConfigurationTab() {
        this.presenter.showConfigurationTab();
        this.presenter.afterPreviewCommand.execute();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
    }

    @Test
    public void testShowPreviewTab() {
        this.presenter.showPreviewTab();
        this.presenter.afterPreviewCommand.execute();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
    }

    @Test
    public void testShowAdvTab() {
        this.presenter.showAdvancedTab();
        this.presenter.afterPreviewCommand.execute();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showAdvancedTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
    }

    @Test
    public void testSetAcceptableValues() {
        List acceptableValues = (List)Mockito.mock(List.class);
        this.presenter.setAcceptableValues(acceptableValues);
        ((DataSetDefColumnsFilterEditor)Mockito.verify((Object)this.columnsAndFilterEditor, (VerificationMode)Mockito.times((int)1))).setAcceptableValues(acceptableValues);
        this.assertViewNotUsed();
    }

    @Test
    public void testBasicAttributesEditor() {
        Util.assertEquals((Object)this.basicAttributesEditor, (Object)this.presenter.basicAttributesEditor());
        this.assertViewNotUsed();
    }

    @Test
    public void testColumnsAndFilterEditor() {
        Util.assertEquals((Object)this.columnsAndFilterEditor, (Object)this.presenter.columnsAndFilterEditor());
        this.assertViewNotUsed();
    }

    @Test
    public void testBackendCacheEditor() {
        Util.assertEquals((Object)this.backendCacheAttributesEditor, (Object)this.presenter.backendCacheEditor());
        this.assertViewNotUsed();
    }

    @Test
    public void testClientCacheEditor() {
        Util.assertEquals((Object)this.clientCacheAttributesEditor, (Object)this.presenter.clientCacheEditor());
        this.assertViewNotUsed();
    }

    @Test
    public void testRefreshEditor() {
        Util.assertEquals((Object)this.refreshEditor, (Object)this.presenter.refreshEditor());
        this.assertViewNotUsed();
    }

    @Test
    public void testOnOpenColumnsFilterPanel() {
        this.presenter.onOpenColumnsFilterPanel();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).openColumnsFilterPanel(ArgumentMatchers.anyString());
    }

    @Test
    public void testOnCloseColumnsFilterPanel() {
        this.presenter.onCloseColumnsFilterPanel();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).closeColumnsFilterPanel(ArgumentMatchers.anyString());
    }

    @Test
    public void testConfigurationTabItemClickHandler() {
        this.presenter.configurationTabItemClickHandler.execute();
        ArgumentCaptor tabChangedEventCaptor = ArgumentCaptor.forClass(TabChangedEvent.class);
        ((EventSourceMock)Mockito.verify(this.tabChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(tabChangedEventCaptor.capture());
        TabChangedEvent tabChangedEvent = (TabChangedEvent)tabChangedEventCaptor.getValue();
        Util.assertEquals(this.presenter, (Object)tabChangedEvent.getContext());
        Util.assertEquals((Object)"configuration", (Object)tabChangedEvent.getTabId());
        this.assertViewNotUsed();
    }

    @Test
    public void testPreviewTabItemClickHandler() {
        this.presenter.previewTabItemClickHandler.execute();
        ArgumentCaptor tabChangedEventCaptor = ArgumentCaptor.forClass(TabChangedEvent.class);
        ((EventSourceMock)Mockito.verify(this.tabChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(tabChangedEventCaptor.capture());
        TabChangedEvent tabChangedEvent = (TabChangedEvent)tabChangedEventCaptor.getValue();
        Util.assertEquals(this.presenter, (Object)tabChangedEvent.getContext());
        Util.assertEquals((Object)"preview", (Object)tabChangedEvent.getTabId());
        this.assertViewNotUsed();
    }

    @Test
    public void testAdvTabItemClickHandler() {
        this.presenter.advancedTabItemClickHandler.execute();
        ArgumentCaptor tabChangedEventCaptor = ArgumentCaptor.forClass(TabChangedEvent.class);
        ((EventSourceMock)Mockito.verify(this.tabChangedEvent, (VerificationMode)Mockito.times((int)1))).fire(tabChangedEventCaptor.capture());
        TabChangedEvent tabChangedEvent = (TabChangedEvent)tabChangedEventCaptor.getValue();
        Util.assertEquals(this.presenter, (Object)tabChangedEvent.getContext());
        Util.assertEquals((Object)"advanced", (Object)tabChangedEvent.getTabId());
        this.assertViewNotUsed();
    }

    @Test
    public void testShowError() {
        ClientRuntimeError error = (ClientRuntimeError)Mockito.mock(ClientRuntimeError.class);
        Mockito.when((Object)error.getCause()).thenReturn((Object)"errorCause");
        this.presenter.afterPreviewCommand = (Command)Mockito.mock(Command.class);
        this.presenter.showError(error);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showErrorNotification((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ErrorEvent.class));
        ((Command)Mockito.verify((Object)this.presenter.afterPreviewCommand, (VerificationMode)Mockito.times((int)1))).execute();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addConfigurationTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addPreviewTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addAdvancedTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).openColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).closeColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearErrorNotification();
    }

    @Test
    public void testOnColumnsChangedEvent() {
        Command afterPreviewCommand;
        DataColumnDef col1 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col1.getId()).thenReturn((Object)"col1");
        Mockito.when((Object)col1.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        DataColumnDef col2 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.NUMBER);
        ArrayList<DataColumnDef> cols = new ArrayList<DataColumnDef>();
        cols.add(col1);
        cols.add(col2);
        ColumnsChangedEvent event = (ColumnsChangedEvent)Mockito.mock(ColumnsChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.columnListEditor);
        Mockito.when((Object)event.getColumns()).thenReturn(cols);
        this.presenter.dataSetDef = this.dataSetDef;
        this.mockPreviewTableCall();
        this.presenter.afterPreviewCommand = afterPreviewCommand = (Command)Mockito.mock(Command.class);
        this.presenter.onColumnsChangedEvent(event);
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setColumns(cols);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearErrorNotification();
        ((DataSetDefFilterEditor)Mockito.verify((Object)this.filterEditor, (VerificationMode)Mockito.times((int)1))).init((DataSetMetadata)ArgumentMatchers.any());
        ((Command)Mockito.verify((Object)afterPreviewCommand, (VerificationMode)Mockito.times((int)1))).execute();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(DataSetEditor.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((DataSetDefBasicAttributesEditor.View)ArgumentMatchers.any(DataSetDefBasicAttributesEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefColumnsFilterEditor.View)ArgumentMatchers.any(DataSetDefColumnsFilterEditor.View.class), (DataSetDefPreviewTable.View)ArgumentMatchers.any(DataSetDefPreviewTable.View.class), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.class), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.class), (DataSetDefRefreshAttributesEditor.View)ArgumentMatchers.any(DataSetDefRefreshAttributesEditor.View.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addConfigurationTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addPreviewTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addAdvancedTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).openColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).closeColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showErrorNotification((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
    }

    @Test
    public void testOnFilterChangedEvent() {
        Command afterPreviewCommand;
        FilterChangedEvent event = (FilterChangedEvent)Mockito.mock(FilterChangedEvent.class);
        DataSetFilter filter = (DataSetFilter)Mockito.mock(DataSetFilter.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.filterEditor);
        Mockito.when((Object)event.getFilter()).thenReturn((Object)filter);
        this.presenter.dataSetDef = this.dataSetDef;
        this.mockPreviewTableCall();
        this.presenter.afterPreviewCommand = afterPreviewCommand = (Command)Mockito.mock(Command.class);
        this.presenter.onFilterChangedEvent(event);
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setDataSetFilter(filter);
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).show();
        ((LoadingBox)Mockito.verify((Object)this.loadingBox, (VerificationMode)Mockito.times((int)1))).hide();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearErrorNotification();
        ((DataSetDefFilterEditor)Mockito.verify((Object)this.filterEditor, (VerificationMode)Mockito.times((int)0))).init((DataSetMetadata)ArgumentMatchers.any(DataSetMetadata.class));
        ((Command)Mockito.verify((Object)afterPreviewCommand, (VerificationMode)Mockito.times((int)1))).execute();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(DataSetEditor.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((DataSetDefBasicAttributesEditor.View)ArgumentMatchers.any(DataSetDefBasicAttributesEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefColumnsFilterEditor.View)ArgumentMatchers.any(DataSetDefColumnsFilterEditor.View.class), (DataSetDefPreviewTable.View)ArgumentMatchers.any(DataSetDefPreviewTable.View.class), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.class), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.class), (DataSetDefRefreshAttributesEditor.View)ArgumentMatchers.any(DataSetDefRefreshAttributesEditor.View.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addConfigurationTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addPreviewTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addAdvancedTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).openColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).closeColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showErrorNotification((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
    }

    protected void mockPreviewTableCall() {
        final Displayer displayer = (Displayer)Mockito.mock(Displayer.class);
        DataSetHandler dataSetHandler = (DataSetHandler)Mockito.mock(DataSetHandler.class);
        DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        Mockito.when((Object)displayer.getDataSetHandler()).thenReturn((Object)dataSetHandler);
        Mockito.when((Object)dataSetHandler.getLastDataSet()).thenReturn((Object)dataSet);
        ((DataSetDefPreviewTable)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                DisplayerListener listener = (DisplayerListener)invocationOnMock.getArguments()[2];
                listener.onDraw(displayer);
                return null;
            }
        }).when((Object)this.previewTable)).show((DataSetDef)ArgumentMatchers.any(DataSetDef.class), (Collection)ArgumentMatchers.any(Collection.class), (DisplayerListener)ArgumentMatchers.any(DisplayerListener.class));
    }

    protected void assertViewNotUsed() {
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.any(DataSetEditor.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((DataSetDefBasicAttributesEditor.View)ArgumentMatchers.any(DataSetDefBasicAttributesEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefColumnsFilterEditor.View)ArgumentMatchers.any(DataSetDefColumnsFilterEditor.View.class), (DataSetDefPreviewTable.View)ArgumentMatchers.any(DataSetDefPreviewTable.View.class), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.class), (DataSetDefCacheAttributesEditorView)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.class), (DataSetDefRefreshAttributesEditor.View)ArgumentMatchers.any(DataSetDefRefreshAttributesEditor.View.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addConfigurationTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addPreviewTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addAdvancedTabItemClickHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).openColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).closeColumnsFilterPanel(ArgumentMatchers.anyString());
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showErrorNotification((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
        ((DataSetEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearErrorNotification();
    }
}

