/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.client.widgets.dataset.editor.column.ColumnListEditor;
import org.dashbuilder.client.widgets.dataset.editor.column.DataSetDefColumnsEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefColumnsEditorTest {
    @Mock
    ColumnListEditor columnListEditor;
    private DataSetDefColumnsEditor presenter;

    @Before
    public void setup() {
        this.presenter = new DataSetDefColumnsEditor(this.columnListEditor);
    }

    @Test
    public void testSetAcceptableValues() {
        List acceptableValues = (List)Mockito.mock(List.class);
        this.presenter.setAcceptableValues(acceptableValues);
        Util.assertEquals((Object)acceptableValues, (Object)this.presenter.acceptableValues);
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)1))).setAcceptableValues(acceptableValues);
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueUnRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setProviderType((DataSetProviderType)ArgumentMatchers.any(DataSetProviderType.class));
    }

    @Test
    public void testOnValueRestricted() {
        String v = "value";
        this.presenter.onValueRestricted("value");
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)1))).onValueRestricted("value");
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueUnRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setProviderType((DataSetProviderType)ArgumentMatchers.any(DataSetProviderType.class));
    }

    @Test
    public void testOnValueUnRestricted() {
        String v = "value";
        this.presenter.onValueUnRestricted("value");
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)1))).onValueUnRestricted("value");
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setProviderType((DataSetProviderType)ArgumentMatchers.any(DataSetProviderType.class));
    }

    @Test
    public void testSetValueBeanType() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)dataSetDef.isAllColumnsEnabled()).thenReturn((Object)false);
        this.presenter.acceptableValues = this.buildAcceptableValues();
        this.presenter.setValue(dataSetDef);
        ((DataSetDef)Mockito.verify((Object)dataSetDef, (VerificationMode)Mockito.times((int)0))).setColumns((List)ArgumentMatchers.any(List.class));
        ((DataSetDef)Mockito.verify((Object)dataSetDef, (VerificationMode)Mockito.times((int)0))).setAllColumnsEnabled(ArgumentMatchers.anyBoolean());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)DataSetProviderType.BEAN);
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueUnRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testSetValueWithNotAllColumns() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.isAllColumnsEnabled()).thenReturn((Object)false);
        this.presenter.acceptableValues = this.buildAcceptableValues();
        this.presenter.setValue(dataSetDef);
        ((DataSetDef)Mockito.verify((Object)dataSetDef, (VerificationMode)Mockito.times((int)0))).setColumns((List)ArgumentMatchers.any(List.class));
        ((DataSetDef)Mockito.verify((Object)dataSetDef, (VerificationMode)Mockito.times((int)0))).setAllColumnsEnabled(ArgumentMatchers.anyBoolean());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)ArgumentMatchers.any(DataSetProviderType.class));
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueUnRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testSetValueWithAllColumns() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.isAllColumnsEnabled()).thenReturn((Object)true);
        this.presenter.acceptableValues = this.buildAcceptableValues();
        this.presenter.setValue(dataSetDef);
        ((DataSetDef)Mockito.verify((Object)dataSetDef, (VerificationMode)Mockito.times((int)1))).setColumns((List)ArgumentMatchers.any(List.class));
        ((DataSetDef)Mockito.verify((Object)dataSetDef, (VerificationMode)Mockito.times((int)1))).setAllColumnsEnabled(false);
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)ArgumentMatchers.any(DataSetProviderType.class));
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueUnRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).onValueRestricted(ArgumentMatchers.anyString());
        ((ColumnListEditor)Mockito.verify((Object)this.columnListEditor, (VerificationMode)Mockito.times((int)0))).setAcceptableValues((List)ArgumentMatchers.any(List.class));
    }

    private List<DataColumnDef> buildAcceptableValues() {
        DataColumnDef col1 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        ArrayList<DataColumnDef> acceptableValues = new ArrayList<DataColumnDef>();
        acceptableValues.add(col1);
        return acceptableValues;
    }
}

