/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.sql;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collection;
import org.dashbuilder.client.widgets.dataset.editor.sql.SQLDataSetDefAttributesEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSourceDef;
import org.dashbuilder.dataset.service.SQLProviderServices;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class SQLDataSetDefAttributesEditorTest {
    @Mock
    DropDownEditor dataSource;
    @Mock
    ValueBoxEditor<String> dbSchema;
    @Mock
    ValueBoxEditor<String> dbTable;
    @Mock
    ValueBoxEditor<String> dbSQL;
    @Mock
    SQLProviderServices sqlProviderServices;
    @Mock
    SQLDataSetDefAttributesEditor.View view;
    Caller<SQLProviderServices> sqlProviderServicesCaller;
    SQLDataSetDefAttributesEditor presenter;
    SQLDataSourceDef dataSourceDef = new SQLDataSourceDef("test", "test");

    @Before
    public void setup() {
        Mockito.when((Object)this.sqlProviderServices.getDataSourceDefs()).thenReturn(Arrays.asList(this.dataSourceDef));
        this.sqlProviderServicesCaller = new CallerMock((Object)this.sqlProviderServices);
        this.presenter = new SQLDataSetDefAttributesEditor(this.dataSource, this.dbSchema, this.dbTable, this.dbSQL, this.sqlProviderServicesCaller, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((DropDownEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any());
        ((DropDownEditor)Mockito.verify((Object)this.dataSource, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSchema, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbTable, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).query();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).table();
        ((SQLProviderServices)Mockito.verify((Object)this.sqlProviderServices)).getDataSourceDefs();
        ((DropDownEditor)Mockito.verify((Object)this.dataSource)).setEntries((Collection)ArgumentMatchers.any());
        ((DropDownEditor)Mockito.verify((Object)this.dataSource)).setSelectHint(ArgumentMatchers.anyString());
    }

    @Test
    public void testDataSource() {
        Assert.assertEquals((Object)this.dataSource, (Object)this.presenter.dataSource());
    }

    @Test
    public void testDbSchema() {
        Assert.assertEquals(this.dbSchema, (Object)this.presenter.dbSchema());
    }

    @Test
    public void testDbTable() {
        Assert.assertEquals(this.dbTable, (Object)this.presenter.dbTable());
    }

    @Test
    public void testDbSQL() {
        Assert.assertEquals(this.dbSQL, (Object)this.presenter.dbSQL());
    }

    @Test
    public void testSetValueUsingTable() {
        SQLDataSetDef dataSetDef = (SQLDataSetDef)Mockito.mock(SQLDataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.getDbTable()).thenReturn((Object)"table1");
        Mockito.when((Object)dataSetDef.getDbSQL()).thenReturn(null);
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)false, (Object)this.presenter.isUsingQuery());
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).table();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((DropDownEditor.View)ArgumentMatchers.any(DropDownEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DropDownEditor)Mockito.verify((Object)this.dataSource, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSchema, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbTable, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).query();
    }

    @Test
    public void testSetValueUsingQuery() {
        SQLDataSetDef dataSetDef = (SQLDataSetDef)Mockito.mock(SQLDataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.getDbTable()).thenReturn(null);
        Mockito.when((Object)dataSetDef.getDbSQL()).thenReturn((Object)"query1");
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)true, (Object)this.presenter.isUsingQuery());
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).query();
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((DropDownEditor.View)ArgumentMatchers.any(DropDownEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DropDownEditor)Mockito.verify((Object)this.dataSource, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSchema, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbTable, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.dbSQL, (VerificationMode)Mockito.times((int)0))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((SQLDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).table();
    }
}

