/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow;

import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.validation.client.impl.ConstraintViolationImpl;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.event.Event;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetEditorWorkflowTest
extends AbstractDataSetWorkflowTest {
    public static final String UUID = "uuid1";
    public static final String NAME = "name1";
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    DataSet dataSet;
    @Mock
    SimpleBeanEditorDriver driver;
    @Mock
    DataSetEditorWorkflow.View view;
    private DataSetEditorWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.presenter = new DataSetEditorWorkflow(this.clientServices, this.validatorProvider, this.beanManager, (Event)this.saveRequestEvent, (Event)this.testDataSetEvent, (Event)this.cancelRequestEvent, this.view){};
        this.presenter.dataSetDef = this.dataSetDef;
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)UUID);
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.dataSet.getUUID()).thenReturn((Object)UUID);
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)0);
        Mockito.when((Object)this.dataSetDef.clone()).thenReturn((Object)this.dataSetDef);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataSetReadyCallback callback = (DataSetReadyCallback)invocationOnMock.getArguments()[2];
                callback.callback(DataSetEditorWorkflowTest.this.dataSet);
                return null;
            }
        }).when((Object)this.clientServices)).lookupDataSet((DataSetDef)ArgumentMatchers.any(this.dataSetDef.getClass()), (DataSetLookup)ArgumentMatchers.any(DataSetLookup.class), (DataSetReadyCallback)ArgumentMatchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testClear() {
        Command c;
        this.presenter.dataSetDef = this.dataSetDef;
        this.presenter.flushCommand = c = (Command)Mockito.mock(Command.class);
        this.presenter.stepValidator = c;
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.getDataSetDef());
        Assert.assertNull((Object)this.presenter.flushCommand);
        Assert.assertNull((Object)this.presenter.stepValidator);
        Assert.assertTrue((boolean)this.presenter.violations.isEmpty());
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearView();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
    }

    @Test(expected=RuntimeException.class)
    public void testDoTestDataSetNotEdited() {
        this.presenter.dataSetDef = null;
        DataSetEditorWorkflow.TestDataSetCallback testDataSetCallback = (DataSetEditorWorkflow.TestDataSetCallback)Mockito.mock(DataSetEditorWorkflow.TestDataSetCallback.class);
        this.presenter.testDataSet(testDataSetCallback);
    }

    @Test
    public void testDoTestDataSet() throws Exception {
        DataSetEditorWorkflow.TestDataSetCallback testDataSetCallback = (DataSetEditorWorkflow.TestDataSetCallback)Mockito.mock(DataSetEditorWorkflow.TestDataSetCallback.class);
        this.presenter.testDataSet(testDataSetCallback);
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setAllColumnsEnabled(true);
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setColumns(null);
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setDataSetFilter(null);
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).clone();
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setCacheEnabled(false);
        ((DataSetEditorWorkflow.TestDataSetCallback)Mockito.verify((Object)testDataSetCallback, (VerificationMode)Mockito.times((int)1))).onSuccess(this.dataSet);
        ((DataSetEditorWorkflow.TestDataSetCallback)Mockito.verify((Object)testDataSetCallback, (VerificationMode)Mockito.times((int)0))).onError((ClientRuntimeError)ArgumentMatchers.any(ClientRuntimeError.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testFlush() {
        Command c;
        this.presenter.flushCommand = c = (Command)Mockito.mock(Command.class);
        this.presenter.flush();
        ((Command)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).execute();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testShowNextButton() {
        this.presenter.showNextButton();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testShowTestButton() {
        this.presenter.showTestButton();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testShowBackButton() {
        this.presenter.showBackButton();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testClearButtons() {
        this.presenter.clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testNoHasErrors() {
        Collection violations = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)violations.isEmpty()).thenReturn((Object)true);
        this.presenter.violations = violations;
        Assert.assertFalse((boolean)this.presenter.hasErrors());
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testHasErrors() {
        Collection violations = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)violations.isEmpty()).thenReturn((Object)false);
        this.presenter.violations = violations;
        Assert.assertTrue((boolean)this.presenter.hasErrors());
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testFlushDriver() {
        Command c;
        Collection violations = (Collection)Mockito.mock(Collection.class);
        Mockito.when((Object)violations.isEmpty()).thenReturn((Object)true);
        this.presenter.violations = violations;
        this.presenter.stepValidator = c = (Command)Mockito.mock(Command.class);
        this.presenter.flush(this.driver);
        ((SimpleBeanEditorDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.times((int)1))).flush();
        ((Command)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).execute();
        Assert.assertFalse((boolean)this.presenter.hasErrors());
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testAddViolations() {
        this.presenter.violations.clear();
        ConstraintViolationImpl v1 = (ConstraintViolationImpl)Mockito.mock(ConstraintViolationImpl.class);
        ArrayList<ConstraintViolationImpl> _violations = new ArrayList<ConstraintViolationImpl>();
        _violations.add(v1);
        this.presenter.addViolations(_violations);
        Assert.assertTrue((boolean)this.presenter.hasErrors());
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testButtonCommand() {
        Command c;
        this.presenter.flushCommand = c = (Command)Mockito.mock(Command.class);
        this.presenter.testButtonCommand.execute();
        ((Command)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).execute();
        ((EventSourceMock)Mockito.verify(this.testDataSetEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(TestDataSetRequestEvent.class));
        ((EventSourceMock)Mockito.verify(this.saveRequestEvent, (VerificationMode)Mockito.times((int)0))).fire(ArgumentMatchers.any(SaveRequestEvent.class));
        ((EventSourceMock)Mockito.verify(this.cancelRequestEvent, (VerificationMode)Mockito.times((int)0))).fire(ArgumentMatchers.any(CancelRequestEvent.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testSaveButtonCommand() {
        Command c;
        this.presenter.flushCommand = c = (Command)Mockito.mock(Command.class);
        this.presenter.saveButtonCommand.execute();
        ((Command)Mockito.verify((Object)c, (VerificationMode)Mockito.times((int)1))).execute();
        ((EventSourceMock)Mockito.verify(this.saveRequestEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(SaveRequestEvent.class));
        ((EventSourceMock)Mockito.verify(this.testDataSetEvent, (VerificationMode)Mockito.times((int)0))).fire(ArgumentMatchers.any(TestDataSetRequestEvent.class));
        ((EventSourceMock)Mockito.verify(this.cancelRequestEvent, (VerificationMode)Mockito.times((int)0))).fire(ArgumentMatchers.any(CancelRequestEvent.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }

    @Test
    public void testCancelButtonCommand() {
        this.presenter.cancelButtonCommand.execute();
        ((EventSourceMock)Mockito.verify(this.cancelRequestEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(CancelRequestEvent.class));
        ((EventSourceMock)Mockito.verify(this.saveRequestEvent, (VerificationMode)Mockito.times((int)0))).fire(ArgumentMatchers.any(SaveRequestEvent.class));
        ((EventSourceMock)Mockito.verify(this.testDataSetEvent, (VerificationMode)Mockito.times((int)0))).fire(ArgumentMatchers.any(TestDataSetRequestEvent.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
    }
}

