/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.TableDisplayerSettingsBuilder;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.DataSetEditHandler;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetDefPreviewTable
implements IsWidget {
    DataSetClientServices clientServices;
    DisplayerLocator displayerLocator;
    public View view;
    Displayer tableDisplayer;

    @Inject
    public DataSetDefPreviewTable(DisplayerLocator displayerLocator, DataSetClientServices clientServices, View view) {
        this.displayerLocator = displayerLocator;
        this.clientServices = clientServices;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void show(DataSetDef dataSetDef, Collection<DataColumnDef> columns, DisplayerListener displayerListener) {
        this.clear();
        if (dataSetDef != null) {
            TableDisplayerSettingsBuilder settingsBuilder = (TableDisplayerSettingsBuilder)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset(dataSetDef.getUUID())).renderer("default")).titleVisible(false)).tablePageSize(10).resizable(true).tableOrderEnabled(true).tableColumnPickerEnabled(false).filterOn(true, false, false);
            if (columns != null && !columns.isEmpty()) {
                for (DataColumnDef column : columns) {
                    settingsBuilder.column(column.getId());
                }
            }
            DataSetDef editCloneWithoutCacheSettings = dataSetDef.clone();
            editCloneWithoutCacheSettings.setCacheEnabled(false);
            if (this.tableDisplayer != null) {
                this.tableDisplayer.close();
            }
            DisplayerSettings settings = settingsBuilder.buildSettings();
            this.tableDisplayer = this.displayerLocator.lookupDisplayer(settings);
            this.tableDisplayer.setDataSetHandler((DataSetHandler)new DataSetEditHandler(this.clientServices, settings.getDataSetLookup(), editCloneWithoutCacheSettings));
            if (dataSetDef instanceof CSVDataSetDef) {
                final CSVDataSetDef csvDataSetDef = (CSVDataSetDef)dataSetDef;
                this.tableDisplayer.addListener(new DisplayerListener[]{new AbstractDisplayerListener(){

                    public void onDataLoaded(Displayer displayer) {
                        DataSetDefPreviewTable.this.configureColumnSettings(displayer, csvDataSetDef);
                    }
                }});
            }
            this.draw(displayerListener);
        }
    }

    protected void configureColumnSettings(Displayer displayer, CSVDataSetDef csvDataSetDef) {
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        dataSet.getColumns().stream().forEach(column -> {
            String pattern;
            if (column.getColumnType().equals((Object)ColumnType.DATE)) {
                String pattern2 = csvDataSetDef.getDatePattern(column.getId());
                if (pattern2 != null) {
                    displayer.getDisplayerSettings().setColumnValuePattern(column.getId(), pattern2);
                }
            } else if (column.getColumnType().equals((Object)ColumnType.NUMBER) && (pattern = csvDataSetDef.getNumberPattern(column.getId())) != null) {
                displayer.getDisplayerSettings().setColumnValuePattern(column.getId(), pattern);
            }
        });
    }

    void draw(DisplayerListener displayerListener) {
        this.tableDisplayer.addListener(new DisplayerListener[]{displayerListener});
        this.view.setDisplayer((IsWidget)this.tableDisplayer);
        this.tableDisplayer.draw();
    }

    public void clear() {
        this.tableDisplayer = null;
        this.view.clear();
    }

    public static interface View
    extends UberView<DataSetDefPreviewTable> {
        public View setDisplayer(IsWidget var1);

        public View clear();
    }
}

