/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.workflow.edit;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.event.Event;
import javax.validation.ConstraintViolation;
import org.dashbuilder.client.widgets.dataset.editor.DataSetEditor;
import org.dashbuilder.client.widgets.dataset.editor.workflow.AbstractDataSetWorkflowTest;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.DataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.SaveRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.dataset.def.DataSetDef;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetEditWorkflowTest
extends AbstractDataSetWorkflowTest {
    public static final String UUID = "uuid1";
    public static final String NAME = "name1";
    @Mock
    SyncBeanManager beanManager;
    @Mock
    EventSourceMock<SaveRequestEvent> saveRequestEvent;
    @Mock
    EventSourceMock<TestDataSetRequestEvent> testDataSetEvent;
    @Mock
    EventSourceMock<CancelRequestEvent> cancelRequestEvent;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    DataSet dataSet;
    @Mock
    DataSetEditorWorkflow.View view;
    @Mock
    DataSetDefRefreshAttributesEditor refreshEditor;
    @Mock
    SyncBeanDef<SimpleBeanEditorDriver> simpleBeanEditorDriverSyncBeanDef;
    @Mock
    SyncBeanDef<DataSetEditor> dataSetEditorSyncBeanDef;
    @Mock
    SimpleBeanEditorDriver driver;
    @Mock
    DataSetEditor editor;
    DataSetEditWorkflow presenter;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)UUID);
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)NAME);
        Mockito.when((Object)this.dataSet.getUUID()).thenReturn((Object)UUID);
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)0);
        Mockito.when((Object)this.dataSetDef.clone()).thenReturn((Object)this.dataSetDef);
        Mockito.when((Object)this.editor.refreshEditor()).thenReturn((Object)this.refreshEditor);
        Mockito.when((Object)this.beanManager.lookupBean(SimpleBeanEditorDriver.class, new Annotation[0])).thenReturn(this.simpleBeanEditorDriverSyncBeanDef);
        Mockito.when((Object)this.simpleBeanEditorDriverSyncBeanDef.newInstance()).thenAnswer((Answer)new Answer<SimpleBeanEditorDriver>(){

            public SimpleBeanEditorDriver answer(InvocationOnMock invocationOnMock) throws Throwable {
                return DataSetEditWorkflowTest.this.driver;
            }
        });
        Mockito.when((Object)this.beanManager.lookupBean(DataSetEditor.class, new Annotation[0])).thenReturn(this.dataSetEditorSyncBeanDef);
        Mockito.when((Object)this.dataSetEditorSyncBeanDef.newInstance()).thenAnswer((Answer)new Answer<DataSetEditor>(){

            public DataSetEditor answer(InvocationOnMock invocationOnMock) throws Throwable {
                return DataSetEditWorkflowTest.this.editor;
            }
        });
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataSetReadyCallback callback = (DataSetReadyCallback)invocationOnMock.getArguments()[2];
                callback.callback(DataSetEditWorkflowTest.this.dataSet);
                return null;
            }
        }).when((Object)this.clientServices)).lookupDataSet((DataSetDef)ArgumentMatchers.any(this.dataSetDef.getClass()), (DataSetLookup)ArgumentMatchers.any(DataSetLookup.class), (DataSetReadyCallback)ArgumentMatchers.any(DataSetReadyCallback.class));
        this.presenter = new DataSetEditWorkflow(this.clientServices, this.validatorProvider, this.beanManager, (Event)this.saveRequestEvent, (Event)this.testDataSetEvent, (Event)this.cancelRequestEvent, this.view){

            protected Class<? extends SimpleBeanEditorDriver> getDriverClass() {
                return SimpleBeanEditorDriver.class;
            }

            protected Class getEditorClass() {
                return DataSetEditor.class;
            }

            protected Iterable<ConstraintViolation<?>> validate(boolean isCacheEnabled, boolean isPushEnabled, boolean isRefreshEnabled) {
                return null;
            }
        };
    }

    @Test
    public void testEdit() {
        List columnDefs = (List)Mockito.mock(List.class);
        this.presenter.edit(this.dataSetDef, columnDefs);
        Assert.assertEquals((Object)this.editor, (Object)this.presenter.getEditor());
        ((SimpleBeanEditorDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.times((int)1))).initialize((Editor)this.editor);
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)1))).setAcceptableValues(columnDefs);
        ((SimpleBeanEditorDriver)Mockito.verify((Object)this.driver, (VerificationMode)Mockito.times((int)1))).edit((Object)this.dataSetDef);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearView();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
    }

    @Test
    public void testShowConfigurationTab() {
        this.presenter.editor = this.editor;
        this.presenter.showConfigurationTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)1))).showConfigurationTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
    }

    @Test
    public void testShowPreviewTab() {
        this.presenter.editor = this.editor;
        this.presenter.showPreviewTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)1))).showPreviewTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)0))).showAdvancedTab();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
    }

    @Test
    public void testShowAdvancedTab() {
        this.presenter.editor = this.editor;
        this.presenter.showAdvancedTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)1))).showAdvancedTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)0))).showPreviewTab();
        ((DataSetEditor)Mockito.verify((Object)this.editor, (VerificationMode)Mockito.times((int)0))).showConfigurationTab();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearView();
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).add((IsWidget)ArgumentMatchers.any(IsWidget.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButton(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (Command)ArgumentMatchers.any(Command.class));
        ((DataSetEditorWorkflow.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearButtons();
    }

    @Test
    public void testFlushDriverRefreshEnabled() throws Exception {
        this.presenter.editor = this.editor;
        Mockito.when((Object)this.refreshEditor.isRefreshEnabled()).thenReturn((Object)true);
        this.presenter.afterFlush();
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)0))).setRefreshTime(null);
    }

    @Test
    public void testFlushDriverRefreshDisabled() throws Exception {
        this.presenter.editor = this.editor;
        this.presenter._setDataSetDef(this.dataSetDef);
        Mockito.when((Object)this.refreshEditor.isRefreshEnabled()).thenReturn((Object)false);
        this.presenter.afterFlush();
        ((DataSetDef)Mockito.verify((Object)this.dataSetDef, (VerificationMode)Mockito.times((int)1))).setRefreshTime(null);
    }
}

