/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.attributes;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefRefreshIntervalEditor;
import org.dashbuilder.common.client.editor.ToggleSwitchEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefRefreshAttributesEditorTest {
    @Mock
    ToggleSwitchEditor refreshAlways;
    @Mock
    DataSetDefRefreshIntervalEditor refreshTime;
    @Mock
    DataSetDefRefreshAttributesEditor.View view;
    private DataSetDefRefreshAttributesEditor presenter;

    @Before
    public void setup() {
        this.presenter = new DataSetDefRefreshAttributesEditor(this.refreshAlways, this.refreshTime, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((DataSetDefRefreshIntervalEditor)Mockito.verify((Object)this.refreshTime, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((IsWidget)ArgumentMatchers.any(), (DataSetDefRefreshIntervalEditor.View)ArgumentMatchers.any());
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addRefreshEnabledButtonHandler((Command)ArgumentMatchers.any(Command.class));
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEnabled(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testRefreshAlways() {
        Assert.assertEquals((Object)this.refreshAlways, (Object)this.presenter.refreshAlways());
    }

    @Test
    public void testRefreshTime() {
        Assert.assertEquals((Object)this.refreshTime, (Object)this.presenter.refreshTime());
    }

    @Test
    public void testRefreshEnabledButtonHandlerDisabled() {
        this.presenter.isRefreshEnabled = false;
        this.presenter.refreshEnabledButtonHandler.execute();
        Assert.assertEquals((Object)true, (Object)this.presenter.isRefreshEnabled());
        ((DataSetDefRefreshIntervalEditor)Mockito.verify((Object)this.refreshTime, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((ToggleSwitchEditor)Mockito.verify((Object)this.refreshAlways, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefRefreshIntervalEditor.View)ArgumentMatchers.any(DataSetDefRefreshIntervalEditor.View.class));
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addRefreshEnabledButtonHandler((Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testRefreshEnabledButtonHandlerEnabled() {
        this.presenter.isRefreshEnabled = true;
        this.presenter.refreshEnabledButtonHandler.execute();
        Assert.assertEquals((Object)false, (Object)this.presenter.isRefreshEnabled());
        ((DataSetDefRefreshIntervalEditor)Mockito.verify((Object)this.refreshTime, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((ToggleSwitchEditor)Mockito.verify((Object)this.refreshAlways, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefRefreshIntervalEditor.View)ArgumentMatchers.any(DataSetDefRefreshIntervalEditor.View.class));
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addRefreshEnabledButtonHandler((Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testSetValueEnabled() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.getRefreshTime()).thenReturn((Object)"1 second");
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)true, (Object)this.presenter.isRefreshEnabled());
        ((DataSetDefRefreshIntervalEditor)Mockito.verify((Object)this.refreshTime, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((ToggleSwitchEditor)Mockito.verify((Object)this.refreshAlways, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefRefreshIntervalEditor.View)ArgumentMatchers.any(DataSetDefRefreshIntervalEditor.View.class));
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addRefreshEnabledButtonHandler((Command)ArgumentMatchers.any(Command.class));
    }

    @Test
    public void testSetValueDisabled() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.getRefreshTime()).thenReturn(null);
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)false, (Object)this.presenter.isRefreshEnabled());
        ((DataSetDefRefreshIntervalEditor)Mockito.verify((Object)this.refreshTime, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((ToggleSwitchEditor)Mockito.verify((Object)this.refreshAlways, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((IsWidget)ArgumentMatchers.any(IsWidget.class), (DataSetDefRefreshIntervalEditor.View)ArgumentMatchers.any(DataSetDefRefreshIntervalEditor.View.class));
        ((DataSetDefRefreshAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addRefreshEnabledButtonHandler((Command)ArgumentMatchers.any(Command.class));
    }
}

