/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.kafka;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.kafka.MetricsTargetEditorAdapter;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.list.DropDownEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.KafkaDataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;

@Dependent
public class KafkaDataSetDefAttributesEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.KafkaDataSetDefAttributesEditor {
    DataSetClientServices dataSetClientServices;
    ValueBoxEditor<String> host;
    ValueBoxEditor<String> port;
    MetricsTargetEditorAdapter target;
    ValueBoxEditor<String> filter;
    ValueBoxEditor<String> clientId;
    ValueBoxEditor<String> nodeId;
    ValueBoxEditor<String> topic;
    ValueBoxEditor<String> partition;
    public View view;
    KafkaDataSetDef value;

    @Inject
    public KafkaDataSetDefAttributesEditor(DataSetClientServices dataSetClientServices, View view, ValueBoxEditor<String> host, ValueBoxEditor<String> port, MetricsTargetEditorAdapter target, ValueBoxEditor<String> filter, ValueBoxEditor<String> clientId, ValueBoxEditor<String> nodeId, ValueBoxEditor<String> topic, ValueBoxEditor<String> partition) {
        this.dataSetClientServices = dataSetClientServices;
        this.view = view;
        this.host = host;
        this.port = port;
        this.target = target;
        this.filter = filter;
        this.clientId = clientId;
        this.nodeId = nodeId;
        this.topic = topic;
        this.partition = partition;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.host.view, this.port.view, this.target.getDropDownEditor().view, this.filter.view, this.clientId.view, this.nodeId.view, this.topic.view, this.partition.view);
        this.host.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_host(), DataSetEditorConstants.INSTANCE.kafka_host_description(), Placement.BOTTOM);
        this.port.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_port(), DataSetEditorConstants.INSTANCE.kafka_port_description(), Placement.BOTTOM);
        this.target.getDropDownEditor().addHelpContent(DataSetEditorConstants.INSTANCE.kafka_target(), DataSetEditorConstants.INSTANCE.kafka_target_description(), Placement.TOP);
        this.filter.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_filter(), DataSetEditorConstants.INSTANCE.kafka_filter_description(), Placement.BOTTOM);
        this.clientId.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_clientId(), DataSetEditorConstants.INSTANCE.kafka_clientId_description(), Placement.BOTTOM);
        this.nodeId.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_nodeId(), DataSetEditorConstants.INSTANCE.kafka_nodeId_description(), Placement.BOTTOM);
        this.topic.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_topic(), DataSetEditorConstants.INSTANCE.kafka_topic_description(), Placement.BOTTOM);
        this.partition.addHelpContent(DataSetEditorConstants.INSTANCE.kafka_partition(), DataSetEditorConstants.INSTANCE.kafka_partition_description(), Placement.BOTTOM);
        this.target.getDropDownEditor().setValue(KafkaDataSetDef.MetricsTarget.BROKER.name());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(KafkaDataSetDef value) {
        this.value = value;
        this.target.setValue(value.getTarget());
        this.updateViewFields(this.value.getTarget());
    }

    public void setDelegate(EditorDelegate<KafkaDataSetDef> delegate) {
    }

    public LeafAttributeEditor<String> host() {
        return this.host;
    }

    public LeafAttributeEditor<String> port() {
        return this.port;
    }

    public LeafAttributeEditor<KafkaDataSetDef.MetricsTarget> target() {
        return this.target;
    }

    public LeafAttributeEditor<String> filter() {
        return this.filter;
    }

    public LeafAttributeEditor<String> clientId() {
        return this.clientId;
    }

    public LeafAttributeEditor<String> nodeId() {
        return this.nodeId;
    }

    public LeafAttributeEditor<String> topic() {
        return this.topic;
    }

    public LeafAttributeEditor<String> partition() {
        return this.partition;
    }

    public void onTargetChanged(@Observes ValueChangeEvent valueChangeEvent) {
        if (valueChangeEvent.getContext() == this.target.getDropDownEditor() && valueChangeEvent.getValue() != null) {
            KafkaDataSetDef.MetricsTarget target = KafkaDataSetDef.MetricsTarget.valueOf((String)valueChangeEvent.getValue().toString());
            this.updateViewFields(target);
        }
    }

    private void updateViewFields(KafkaDataSetDef.MetricsTarget target) {
        switch (target) {
            case BROKER: {
                this.view.brokerFields();
                break;
            }
            case CONSUMER: {
                this.view.consumerConstraints();
                break;
            }
            case PRODUCER: {
                this.view.producerConstraints();
            }
        }
    }

    public static interface View
    extends UberView<KafkaDataSetDefAttributesEditor> {
        public void initWidgets(ValueBoxEditor.View var1, ValueBoxEditor.View var2, DropDownEditor.View var3, ValueBoxEditor.View var4, ValueBoxEditor.View var5, ValueBoxEditor.View var6, ValueBoxEditor.View var7, ValueBoxEditor.View var8);

        public void brokerFields();

        public void consumerConstraints();

        public void producerConstraints();
    }
}

