/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.adapters.ListEditor;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.client.widgets.dataset.editor.column.ColumnListEditor;
import org.dashbuilder.client.widgets.dataset.editor.column.DataColumnDefEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.DataColumnDefDriver;
import org.dashbuilder.client.widgets.dataset.event.ColumnsChangedEvent;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ColumnListEditorTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DataColumnDefDriver dataColumnDefDriver;
    @Mock
    EventSourceMock<ColumnsChangedEvent> columnsChangedEvent;
    @Mock
    ColumnListEditor.View view;
    @Mock
    SyncBeanDef<DataColumnDefEditor> columnDefEditorSyncBeanDef;
    @Mock
    DataColumnDefEditor dataColumnDefEditor;
    private ColumnListEditor presenter;
    final ListEditor<DataColumnDef, org.dashbuilder.dataset.client.editor.DataColumnDefEditor> listEditor = (ListEditor)Mockito.mock(ListEditor.class);
    @Mock
    DataColumnDef col1;

    @Before
    public void setup() {
        List<DataColumnDef> acceptableValues;
        this.presenter = new ColumnListEditor(this.beanManager, this.dataColumnDefDriver, this.columnsChangedEvent, this.view);
        Mockito.when((Object)this.beanManager.lookupBean(DataColumnDefEditor.class, new Annotation[0])).thenReturn(this.columnDefEditorSyncBeanDef);
        Mockito.when((Object)((DataColumnDefEditor)this.columnDefEditorSyncBeanDef.newInstance())).thenAnswer((Answer)new Answer<DataColumnDefEditor>(){

            public DataColumnDefEditor answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ColumnListEditorTest.this.dataColumnDefEditor;
            }
        });
        Mockito.when((Object)this.col1.getId()).thenReturn((Object)"col1");
        Mockito.when((Object)this.col1.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        this.presenter.acceptableColumns = acceptableValues = this.buildAcceptableValues();
        ValueBoxEditor id = (ValueBoxEditor)Mockito.mock(ValueBoxEditor.class);
        Mockito.when((Object)((String)id.getValue())).thenReturn((Object)"col1");
        Mockito.when((Object)this.dataColumnDefEditor.id()).thenReturn((Object)id);
        ArrayList<DataColumnDefEditor> editors = new ArrayList<DataColumnDefEditor>();
        ArrayList<DataColumnDef> columns = new ArrayList<DataColumnDef>();
        columns.add(this.col1);
        editors.add(this.dataColumnDefEditor);
        Mockito.when((Object)this.listEditor.getEditors()).thenReturn(editors);
        Mockito.when((Object)this.listEditor.getList()).thenReturn(columns);
        this.presenter.listEditor = this.listEditor;
    }

    @Test
    public void testInit() {
        this.presenter.init();
        Assert.assertNotNull((Object)this.presenter.listEditor);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(DataColumnDefEditor.View.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testClear() {
        this.presenter.clear();
        Assert.assertNull((Object)this.presenter.acceptableColumns);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(DataColumnDefEditor.View.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).remove(ArgumentMatchers.anyInt());
    }

    @Test
    public void testSetAcceptableValues() {
        List<DataColumnDef> acceptableValues = this.buildAcceptableValues();
        this.presenter.setAcceptableValues(acceptableValues);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
        ((DataColumnDefDriver)Mockito.verify((Object)this.dataColumnDefDriver, (VerificationMode)Mockito.times((int)1))).initialize((Editor)this.dataColumnDefEditor);
        ((DataColumnDefDriver)Mockito.verify((Object)this.dataColumnDefDriver, (VerificationMode)Mockito.times((int)1))).edit((Object)this.col1);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).remove(ArgumentMatchers.anyInt());
    }

    @Test
    public void testOnValueRestricted() {
        String value = "col1";
        this.presenter.restrictedColumns.clear();
        this.presenter.onValueRestricted("col1");
        Assert.assertEquals((long)1L, (long)this.presenter.restrictedColumns.size());
        Assert.assertEquals((Object)"col1", this.presenter.restrictedColumns.get(0));
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testOnValueUnRestrictedSingleColumn() {
        String value = "col1";
        this.presenter.restrictedColumns.add("col1");
        this.presenter.onValueUnRestricted("col1");
        Assert.assertTrue((boolean)this.presenter.restrictedColumns.isEmpty());
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testOnValueUnRestricted() {
        String value = "col1";
        this.presenter.restrictedColumns.add("col1");
        DataColumnDef col2 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        this.presenter.listEditor.getList().add(col2);
        this.presenter.onValueUnRestricted("col1");
        Assert.assertTrue((boolean)this.presenter.restrictedColumns.isEmpty());
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).isEditMode(true);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testCreateEditorForTraversal() {
        this.presenter.createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).getPathElement((Editor)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)ArgumentMatchers.any(DataColumnDefEditor.class)));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setEditorChain((CompositeEditor.EditorChain)ArgumentMatchers.any(CompositeEditor.EditorChain.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setDelegate((EditorDelegate)ArgumentMatchers.any(EditorDelegate.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).onPropertyChange(new String[]{ArgumentMatchers.anyString()});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setValue((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testGetPathElement() {
        this.presenter.getPathElement((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)this.dataColumnDefEditor);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).getPathElement((Editor)this.dataColumnDefEditor);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setEditorChain((CompositeEditor.EditorChain)ArgumentMatchers.any(CompositeEditor.EditorChain.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setDelegate((EditorDelegate)ArgumentMatchers.any(EditorDelegate.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).onPropertyChange(new String[]{ArgumentMatchers.anyString()});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setValue((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testSetEditorChain() {
        CompositeEditor.EditorChain chain = (CompositeEditor.EditorChain)Mockito.mock(CompositeEditor.EditorChain.class);
        this.presenter.setEditorChain(chain);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).setEditorChain(chain);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).getPathElement((Editor)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)ArgumentMatchers.any(DataColumnDefEditor.class)));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setDelegate((EditorDelegate)ArgumentMatchers.any(EditorDelegate.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).onPropertyChange(new String[]{ArgumentMatchers.anyString()});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setValue((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testSetDelegate() {
        EditorDelegate delegate = (EditorDelegate)Mockito.mock(EditorDelegate.class);
        this.presenter.setDelegate(delegate);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).setDelegate(delegate);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).getPathElement((Editor)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)ArgumentMatchers.any(DataColumnDefEditor.class)));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setEditorChain((CompositeEditor.EditorChain)ArgumentMatchers.any(CompositeEditor.EditorChain.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).onPropertyChange(new String[]{ArgumentMatchers.anyString()});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setValue((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testFlush() {
        this.presenter.flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).getPathElement((Editor)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)ArgumentMatchers.any(DataColumnDefEditor.class)));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setEditorChain((CompositeEditor.EditorChain)ArgumentMatchers.any(CompositeEditor.EditorChain.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setDelegate((EditorDelegate)ArgumentMatchers.any(EditorDelegate.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).onPropertyChange(new String[]{ArgumentMatchers.anyString()});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setValue((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testOnPropertyChange() {
        String s = "prop1";
        this.presenter.onPropertyChange(new String[]{"prop1"});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).onPropertyChange(new String[]{"prop1"});
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).getPathElement((Editor)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)ArgumentMatchers.any(DataColumnDefEditor.class)));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setEditorChain((CompositeEditor.EditorChain)ArgumentMatchers.any(CompositeEditor.EditorChain.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setDelegate((EditorDelegate)ArgumentMatchers.any(EditorDelegate.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setValue((List)ArgumentMatchers.any(List.class));
    }

    @Test
    public void testSetValue() {
        List value = (List)Mockito.mock(List.class);
        this.presenter.setValue(value);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)1))).setValue(value);
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).createEditorForTraversal();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).getPathElement((Editor)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)ArgumentMatchers.any(DataColumnDefEditor.class)));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setEditorChain((CompositeEditor.EditorChain)ArgumentMatchers.any(CompositeEditor.EditorChain.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).setDelegate((EditorDelegate)ArgumentMatchers.any(EditorDelegate.class));
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).flush();
        ((ListEditor)Mockito.verify(this.listEditor, (VerificationMode)Mockito.times((int)0))).onPropertyChange(new String[]{ArgumentMatchers.anyString()});
    }

    @Test
    public void testSetProviderType() {
        DataSetProviderType type = (DataSetProviderType)Mockito.mock(DataSetProviderType.class);
        this.presenter.setProviderType(type);
        Assert.assertEquals((Object)type, (Object)this.presenter.providerType);
    }

    @Test
    public void testOnColumnSelected() {
        this.listEditor.getList().clear();
        Mockito.when((Object)this.col1.clone()).thenReturn((Object)this.col1);
        this.presenter.onColumnSelect(0, true);
        Assert.assertEquals((long)1L, (long)this.listEditor.getList().size());
        Assert.assertEquals((Object)this.col1, this.listEditor.getList().get(0));
        ((EventSourceMock)Mockito.verify(this.columnsChangedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((ColumnsChangedEvent)ArgumentMatchers.any(ColumnsChangedEvent.class)));
    }

    @Test
    public void testOnColumnUnSelected() {
        Mockito.when((Object)this.col1.clone()).thenReturn((Object)this.col1);
        this.presenter.onColumnSelect(0, false);
        Assert.assertTrue((boolean)this.listEditor.getList().isEmpty());
        ((EventSourceMock)Mockito.verify(this.columnsChangedEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((ColumnsChangedEvent)ArgumentMatchers.any(ColumnsChangedEvent.class)));
    }

    @Test
    public void testDataColumnDefEditorSource_Create() {
        ColumnListEditor.DataColumnDefEditorSource source = this.presenter.createDataColumnDefEditorSource();
        org.dashbuilder.dataset.client.editor.DataColumnDefEditor e = source.create(0);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)2))).isEditMode(false);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)ArgumentMatchers.any());
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setOriginalColumnType((ColumnType)ArgumentMatchers.any(ColumnType.class));
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testDataColumnDefEditorSource_CreateMultiple() {
        DataColumnDef col2 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        this.presenter.acceptableColumns.add(col2);
        this.presenter.listEditor.getList().add(col2);
        this.presenter.restrictedColumns.clear();
        ColumnListEditor.DataColumnDefEditorSource source = this.presenter.createDataColumnDefEditorSource();
        org.dashbuilder.dataset.client.editor.DataColumnDefEditor e = source.create(0);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)2))).isEditMode(true);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setOriginalColumnType((ColumnType)ArgumentMatchers.any(ColumnType.class));
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testDataColumnDefEditorSource_Create_DASHBUILDE79_A() {
        DataColumnDef col2 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        this.presenter.acceptableColumns.add(col2);
        this.presenter.listEditor.getList().add(col2);
        this.presenter.listEditor.getEditors().clear();
        this.presenter.restrictedColumns.clear();
        ColumnListEditor.DataColumnDefEditorSource source = this.presenter.createDataColumnDefEditorSource();
        org.dashbuilder.dataset.client.editor.DataColumnDefEditor e = source.create(0);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).isEditMode(true);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setOriginalColumnType((ColumnType)ArgumentMatchers.any(ColumnType.class));
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testDataColumnDefEditorSource_Create_DASHBUILDE79_B() {
        DataColumnDef col2 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        this.presenter.acceptableColumns.add(col2);
        this.presenter.listEditor.getList().clear();
        this.presenter.listEditor.getList().add(col2);
        this.presenter.listEditor.getEditors().clear();
        this.presenter.restrictedColumns.clear();
        ColumnListEditor.DataColumnDefEditorSource source = this.presenter.createDataColumnDefEditorSource();
        org.dashbuilder.dataset.client.editor.DataColumnDefEditor e = source.create(0);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).isEditMode(false);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setOriginalColumnType((ColumnType)ArgumentMatchers.any(ColumnType.class));
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).setProviderType((DataSetProviderType)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testDataColumnDefEditorSource_Dispose() {
        ColumnListEditor.DataColumnDefEditorSource source = this.presenter.createDataColumnDefEditorSource();
        source.dispose((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)this.dataColumnDefEditor);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)1))).removeFromParent();
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)3))).isEditMode(false);
        ((DataColumnDefDriver)Mockito.verify((Object)this.dataColumnDefDriver, (VerificationMode)Mockito.times((int)1))).initialize((Editor)this.dataColumnDefEditor);
        ((DataColumnDefDriver)Mockito.verify((Object)this.dataColumnDefDriver, (VerificationMode)Mockito.times((int)1))).edit((Object)this.col1);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    @Test
    public void testDataColumnDefEditorSource_Dispose_UniqueColumn() {
        DataColumnDef col2 = (DataColumnDef)Mockito.mock(DataColumnDef.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        final DataColumnDefEditor col2Editor = (DataColumnDefEditor)Mockito.mock(DataColumnDefEditor.class);
        ValueBoxEditor id2 = (ValueBoxEditor)Mockito.mock(ValueBoxEditor.class);
        Mockito.when((Object)((String)id2.getValue())).thenReturn((Object)"col2");
        Mockito.when((Object)col2Editor.id()).thenReturn((Object)id2);
        this.presenter.acceptableColumns.add(col2);
        this.presenter.listEditor.getList().add(col2);
        this.presenter.listEditor.getEditors().add(col2Editor);
        Mockito.when((Object)((DataColumnDefEditor)this.columnDefEditorSyncBeanDef.newInstance())).thenAnswer((Answer)new Answer<DataColumnDefEditor>(){

            public DataColumnDefEditor answer(InvocationOnMock invocationOnMock) throws Throwable {
                return col2Editor;
            }
        });
        ColumnListEditor.DataColumnDefEditorSource source = this.presenter.createDataColumnDefEditorSource();
        source.dispose((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)col2Editor);
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)0))).removeFromParent();
        ((DataColumnDefEditor)Mockito.verify((Object)this.dataColumnDefEditor, (VerificationMode)Mockito.times((int)0))).isEditMode(false);
        ((DataColumnDefEditor)Mockito.verify((Object)col2Editor, (VerificationMode)Mockito.times((int)1))).removeFromParent();
        ((DataColumnDefEditor)Mockito.verify((Object)col2Editor, (VerificationMode)Mockito.times((int)2))).isEditMode(false);
        ((DataColumnDefDriver)Mockito.verify((Object)this.dataColumnDefDriver, (VerificationMode)Mockito.times((int)1))).initialize((Editor)col2Editor);
        ((DataColumnDefDriver)Mockito.verify((Object)this.dataColumnDefDriver, (VerificationMode)Mockito.times((int)1))).edit((Object)col2);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).insert(ArgumentMatchers.anyInt(), (DataColumnDefEditor.View)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (String)ArgumentMatchers.any());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).remove(ArgumentMatchers.anyInt());
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ColumnListEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clear();
    }

    protected List<DataColumnDef> buildAcceptableValues() {
        ArrayList<DataColumnDef> acceptableValues = new ArrayList<DataColumnDef>();
        acceptableValues.add(this.col1);
        return acceptableValues;
    }
}

