/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.column;

import com.google.gwt.editor.client.CompositeEditor;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.editor.client.adapters.EditorSource;
import com.google.gwt.editor.client.adapters.ListEditor;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.dataset.editor.column.DataColumnDefEditor;
import org.dashbuilder.client.widgets.dataset.editor.driver.DataColumnDefDriver;
import org.dashbuilder.client.widgets.dataset.event.ColumnsChangedEvent;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ColumnListEditor
implements IsWidget,
org.dashbuilder.dataset.client.editor.ColumnListEditor {
    SyncBeanManager beanManager;
    DataColumnDefDriver dataColumnDefDriver;
    Event<ColumnsChangedEvent> columnsChangedEvent;
    public View view;
    ListEditor<DataColumnDef, org.dashbuilder.dataset.client.editor.DataColumnDefEditor> listEditor;
    List<DataColumnDef> acceptableColumns;
    final List<String> restrictedColumns = new LinkedList<String>();
    DataSetProviderType providerType;

    @Inject
    public ColumnListEditor(SyncBeanManager beanManager, DataColumnDefDriver dataColumnDefDriver, Event<ColumnsChangedEvent> columnsChangedEvent, View view) {
        this.beanManager = beanManager;
        this.dataColumnDefDriver = dataColumnDefDriver;
        this.columnsChangedEvent = columnsChangedEvent;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.listEditor = ListEditor.of((EditorSource)this.createDataColumnDefEditorSource());
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setAcceptableValues(List<DataColumnDef> acceptableValues) {
        this.clear();
        this.acceptableColumns = new LinkedList<DataColumnDef>(acceptableValues);
        int index = 0;
        for (DataColumnDef columnDef : this.acceptableColumns) {
            DataColumnDefEditor editor = this.createDummyColumnEditor(columnDef);
            this.view.insert(index, editor.view, false, true, null);
            ++index;
        }
    }

    public void onValueRestricted(String value) {
        this.restrictedColumns.add(value);
        this.setEditorEnabled(value, false, DataSetEditorConstants.INSTANCE.columnIsUsedInFilter());
    }

    public void onValueUnRestricted(String value) {
        this.restrictedColumns.remove(value);
        if (this.listEditor.getList().size() == 1) {
            this.setEditorEnabled(0, false, DataSetEditorConstants.INSTANCE.dataSetMustHaveAtLeastOneColumn());
        } else {
            this.setEditorEnabled(value, true, null);
        }
    }

    public void setProviderType(DataSetProviderType type) {
        this.providerType = type;
    }

    public void clear() {
        this.acceptableColumns = null;
        this.providerType = null;
        this.view.clear();
    }

    public org.dashbuilder.dataset.client.editor.DataColumnDefEditor createEditorForTraversal() {
        return (org.dashbuilder.dataset.client.editor.DataColumnDefEditor)this.listEditor.createEditorForTraversal();
    }

    public String getPathElement(org.dashbuilder.dataset.client.editor.DataColumnDefEditor subEditor) {
        return this.listEditor.getPathElement((Editor)subEditor);
    }

    public void setEditorChain(CompositeEditor.EditorChain<DataColumnDef, org.dashbuilder.dataset.client.editor.DataColumnDefEditor> chain) {
        this.listEditor.setEditorChain(chain);
    }

    public void setDelegate(EditorDelegate<List<DataColumnDef>> delegate) {
        this.listEditor.setDelegate(delegate);
    }

    public void showErrors(List<EditorError> errors) {
    }

    public void flush() {
        this.listEditor.flush();
    }

    public void onPropertyChange(String ... paths) {
        this.listEditor.onPropertyChange(paths);
    }

    public void setValue(List<DataColumnDef> value) {
        this.listEditor.setValue(value);
    }

    void onColumnSelect(int index, boolean selected) {
        DataColumnDef columnDef = this.acceptableColumns.get(index);
        if (selected) {
            this.listEditor.getList().add(columnDef.clone());
        } else {
            this.listEditor.getList().remove(columnDef);
        }
        this.columnsChangedEvent.fire((Object)new ColumnsChangedEvent(this, this.listEditor.getList()));
    }

    private void replace(int index, DataColumnDefEditor columnEditor, boolean selected, boolean enabled, String altText) {
        this.view.remove(index);
        columnEditor.isEditMode(selected && enabled);
        this.view.insert(index, columnEditor.view, selected, enabled, altText);
    }

    private int getAvailableColumnIndex(String id) {
        int x = 0;
        for (DataColumnDef column : this.acceptableColumns) {
            if (column.getId().equals(id)) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    DataColumnDefEditorSource createDataColumnDefEditorSource() {
        return new DataColumnDefEditorSource();
    }

    private boolean checkSingleColumnEditorDisabled() {
        boolean hasEditors;
        int size = this.listEditor.getList().size();
        boolean bl = hasEditors = !this.listEditor.getEditors().isEmpty();
        if (size == 1 && hasEditors) {
            this.setEditorEnabled(0, false, DataSetEditorConstants.INSTANCE.dataSetMustHaveAtLeastOneColumn());
            return true;
        }
        return false;
    }

    private boolean checkMultipleColumnsEditorEnabled() {
        int size = this.listEditor.getList().size();
        if (size == 2 && !this.listEditor.getEditors().isEmpty()) {
            String cId = (String)((org.dashbuilder.dataset.client.editor.DataColumnDefEditor)this.listEditor.getEditors().get(0)).id().getValue();
            if (!this.restrictedColumns.contains(cId)) {
                this.setEditorEnabled(0, true, null);
            }
            return true;
        }
        return false;
    }

    private void setEditorEnabled(String columnId, boolean enabled, String altText) {
        DataColumnDefEditor e = this.getEditor(columnId);
        if (e != null) {
            this.setEditorEnabled(e, enabled, altText);
        }
    }

    private void setEditorEnabled(int index, boolean enabled, String altText) {
        DataColumnDefEditor _e = (DataColumnDefEditor)this.listEditor.getEditors().get(index);
        if (_e != null) {
            this.setEditorEnabled(_e, enabled, altText);
        }
    }

    private void setEditorEnabled(DataColumnDefEditor _e, boolean enabled, String altText) {
        String cId = (String)_e.id().getValue();
        int _index = this.getAvailableColumnIndex(cId);
        if (_index > -1) {
            this.replace(_index, _e, true, enabled, altText);
        }
    }

    private void doSetOriginalColumnType(String cId, org.dashbuilder.dataset.client.editor.DataColumnDefEditor editor) {
        int _index = this.getAvailableColumnIndex(cId);
        DataColumnDef originalCol = this.acceptableColumns.get(_index);
        if (originalCol != null) {
            editor.setOriginalColumnType(originalCol.getColumnType());
        }
    }

    private DataColumnDefEditor getEditor(String columnId) {
        List editors = this.listEditor.getEditors();
        if (editors != null && !editors.isEmpty()) {
            for (org.dashbuilder.dataset.client.editor.DataColumnDefEditor editor : editors) {
                String cId = (String)editor.id().getValue();
                if (!columnId.equals(cId)) continue;
                return (DataColumnDefEditor)editor;
            }
        }
        return null;
    }

    private DataColumnDefEditor createColumnEditor() {
        DataColumnDefEditor e = (DataColumnDefEditor)this.beanManager.lookupBean(DataColumnDefEditor.class, new Annotation[0]).newInstance();
        e.setProviderType(this.providerType);
        return e;
    }

    private DataColumnDefEditor createDummyColumnEditor(DataColumnDef def) {
        DataColumnDefEditor editor = this.createColumnEditor();
        editor.isEditMode(false);
        this.dataColumnDefDriver.initialize((Editor)editor);
        this.dataColumnDefDriver.edit(def);
        this.doSetOriginalColumnType(def.getId(), editor);
        return editor;
    }

    class DataColumnDefEditorSource
    extends EditorSource<org.dashbuilder.dataset.client.editor.DataColumnDefEditor> {
        DataColumnDefEditorSource() {
        }

        public org.dashbuilder.dataset.client.editor.DataColumnDefEditor create(int index) {
            DataColumnDef column = (DataColumnDef)ColumnListEditor.this.listEditor.getList().get(index);
            int localIndex = ColumnListEditor.this.acceptableColumns.indexOf(column);
            if (!ColumnListEditor.this.checkSingleColumnEditorDisabled()) {
                ColumnListEditor.this.checkMultipleColumnsEditorEnabled();
            }
            DataColumnDefEditor editor = ColumnListEditor.this.createColumnEditor();
            boolean hasSingleColumn = ColumnListEditor.this.listEditor.getList().size() == 1;
            boolean isRestricted = ColumnListEditor.this.restrictedColumns.contains(column.getId());
            String tooltipText = hasSingleColumn ? DataSetEditorConstants.INSTANCE.dataSetMustHaveAtLeastOneColumn() : (isRestricted ? DataSetEditorConstants.INSTANCE.columnIsUsedInFilter() : null);
            ColumnListEditor.this.doSetOriginalColumnType(column.getId(), editor);
            ColumnListEditor.this.replace(localIndex, editor, true, !isRestricted && !hasSingleColumn, tooltipText);
            return editor;
        }

        public void dispose(org.dashbuilder.dataset.client.editor.DataColumnDefEditor subEditor) {
            String columnId = (String)subEditor.id().getValue();
            int localIndex = ColumnListEditor.this.getAvailableColumnIndex(columnId);
            if (localIndex > -1) {
                DataColumnDef column = ColumnListEditor.this.acceptableColumns.get(localIndex);
                super.dispose((Editor)subEditor);
                subEditor.removeFromParent();
                DataColumnDefEditor editor = ColumnListEditor.this.createDummyColumnEditor(column);
                ColumnListEditor.this.replace(localIndex, editor, false, true, null);
                ColumnListEditor.this.checkSingleColumnEditorDisabled();
            }
        }
    }

    public static interface View
    extends UberView<ColumnListEditor> {
        public View insert(int var1, DataColumnDefEditor.View var2, boolean var3, boolean var4, String var5);

        public View remove(int var1);

        public View clear();
    }
}

