/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Iterator;
import org.dashbuilder.client.widgets.common.CustomDataSetProviderType;
import org.dashbuilder.client.widgets.common.DataSetEditorPlugin;
import org.dashbuilder.client.widgets.dataset.event.EditDataSetEvent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetPanel;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetSummary;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetPanelTest {
    @Mock
    DataSetSummary dataSetSummary;
    @Mock
    EventSourceMock<EditDataSetEvent> editDataSetEvent;
    @Mock
    DataSetPanel.View view;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    ManagedInstance<DataSetEditorPlugin> dataSetEditorPlugin;
    @Mock
    DataSetEditorPlugin pluginEditor;
    private DataSetPanel presenter;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        Mockito.when((Object)this.view.asWidget()).thenReturn((Object)widget);
        this.presenter = (DataSetPanel)Mockito.spy((Object)new DataSetPanel(this.dataSetSummary, this.editDataSetEvent, this.view, this.dataSetEditorPlugin));
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).configure((DataSetSummary.View)ArgumentMatchers.any());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SafeUri)ArgumentMatchers.any(SafeUri.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(ArgumentMatchers.anyString(), (ClickHandler)ArgumentMatchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testAsWidget() throws Exception {
        Util.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testClose() throws Exception {
        this.presenter.close();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)ArgumentMatchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SafeUri)ArgumentMatchers.any(SafeUri.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(ArgumentMatchers.anyString(), (ClickHandler)ArgumentMatchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testDisable() throws Exception {
        this.presenter.disable();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)ArgumentMatchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SafeUri)ArgumentMatchers.any(SafeUri.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(ArgumentMatchers.anyString(), (ClickHandler)ArgumentMatchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).disableActionButton();
    }

    @Test
    public void testShow() throws Exception {
        String iconTitle = "iconTitle";
        ((DataSetPanel)Mockito.doReturn((Object)"iconTitle").when((Object)this.presenter)).getTypeIconTitle(this.dataSetDef);
        SafeUri iconUri = (SafeUri)Mockito.mock(SafeUri.class);
        ((DataSetPanel)Mockito.doReturn((Object)iconUri).when((Object)this.presenter)).getTypeIconUri(this.dataSetDef);
        String parentPanelId = "parentPanel";
        this.presenter.show(this.dataSetDef, "parentPanel");
        Util.assertEquals((Object)this.dataSetDef, (Object)this.presenter.getDataSetDef());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)ArgumentMatchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showHeader("uuid1", "parentPanel", iconUri, "iconTitle", "name1");
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).enableActionButton(ArgumentMatchers.anyString(), (ClickHandler)ArgumentMatchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testOpen() throws Exception {
        this.presenter.def = this.dataSetDef;
        this.presenter.open();
        ((DataSetSummary)Mockito.verify((Object)this.dataSetSummary, (VerificationMode)Mockito.times((int)1))).show(this.dataSetDef);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).configure((DataSetSummary.View)ArgumentMatchers.any(DataSetSummary.View.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showHeader(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (SafeUri)ArgumentMatchers.any(SafeUri.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).hideSummary();
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableActionButton(ArgumentMatchers.anyString(), (ClickHandler)ArgumentMatchers.any(ClickHandler.class));
        ((DataSetPanel.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).disableActionButton();
    }

    @Test
    public void testEditorPlugin() throws Exception {
        Mockito.when((Object)this.pluginEditor.getProviderType()).thenReturn((Object)new CustomDataSetProviderType());
        Mockito.when((Object)this.pluginEditor.getTypeSelectorTitle()).thenReturn((Object)"Custom");
        Mockito.when((Object)this.pluginEditor.getTypeSelectorImageUri()).thenReturn((Object)((SafeUri)Mockito.mock(SafeUri.class)));
        Mockito.when((Object)this.dataSetEditorPlugin.isUnsatisfied()).thenReturn((Object)false);
        Mockito.when((Object)this.dataSetEditorPlugin.iterator()).thenReturn(Arrays.asList(this.pluginEditor).iterator(), (Object[])new Iterator[]{Arrays.asList(this.pluginEditor).iterator()});
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)new CustomDataSetProviderType());
        this.presenter.def = this.dataSetDef;
        String parentPanelId = "parentPanel";
        this.presenter.show(this.dataSetDef, "parentPanel");
        ((ManagedInstance)Mockito.verify(this.dataSetEditorPlugin, (VerificationMode)Mockito.times((int)2))).isUnsatisfied();
        ((ManagedInstance)Mockito.verify(this.dataSetEditorPlugin, (VerificationMode)Mockito.times((int)2))).iterator();
        ((DataSetEditorPlugin)Mockito.verify((Object)this.pluginEditor, (VerificationMode)Mockito.times((int)1))).getTypeSelectorImageUri();
        ((DataSetEditorPlugin)Mockito.verify((Object)this.pluginEditor, (VerificationMode)Mockito.times((int)1))).getTypeSelectorTitle();
    }
}

