/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.explorer;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetSummary;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetSummaryTest {
    @Mock
    DataSetClientServices dataSetClientServices;
    @Mock
    ClientDataSetManager clientDataSetManager;
    @Mock
    EventSourceMock<ErrorEvent> errorEvent;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    DataSetSummary.View view;
    private DataSetSummary presenter;
    final DataSetMetadata dataSetMetadata = (DataSetMetadata)Mockito.mock(DataSetMetadata.class);

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)this.dataSetDef.isCacheEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSetDef.isPushEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSetDef.isRefreshAlways()).thenReturn((Object)true);
        Mockito.when((Object)this.dataSetDef.getRefreshTime()).thenReturn((Object)"1second");
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataSetMetadataCallback callback = (DataSetMetadataCallback)invocationOnMock.getArguments()[1];
                callback.callback(DataSetSummaryTest.this.dataSetMetadata);
                return null;
            }
        }).when((Object)this.dataSetClientServices)).fetchMetadata(ArgumentMatchers.anyString(), (DataSetMetadataCallback)ArgumentMatchers.any(DataSetMetadataCallback.class));
        Widget widget = (Widget)Mockito.mock(Widget.class);
        Mockito.when((Object)this.view.asWidget()).thenReturn((Object)widget);
        this.presenter = new DataSetSummary(this.dataSetClientServices, this.errorEvent, this.view);
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showStatusPanel(Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testAsWidget() throws Exception {
        Util.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testShow() throws Exception {
        int estimatedSize = 100;
        int rowCount = 10;
        Mockito.when((Object)this.dataSetMetadata.getEstimatedSize()).thenReturn((Object)100);
        Mockito.when((Object)this.dataSetMetadata.getNumberOfRows()).thenReturn((Object)10);
        this.presenter.show(this.dataSetDef);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showStatusPanel(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    public void testHumanReadableByteCount() throws Exception {
        long estimatedSize = 2024L;
        String s = this.presenter.humanReadableByteCount(estimatedSize);
    }

    public void testHumanReadableRowCount() throws Exception {
        long rows = 1000L;
        String s = this.presenter.humanReadableRowCount(rows);
    }

    @Test
    public void testShowLoadingIcon() {
        this.presenter.showLoadingIcon();
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showStatusPanel(Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testShowErrorIcon() {
        this.presenter.showErrorIcon();
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showStatusPanel(Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testShowClientRuntimeError() {
        ClientRuntimeError error = (ClientRuntimeError)Mockito.mock(ClientRuntimeError.class);
        this.presenter.showError("uuid1", error);
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((ErrorEvent)ArgumentMatchers.any(ErrorEvent.class)));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showStatusPanel(Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testShowThrowable() {
        Throwable error = (Throwable)Mockito.mock(Throwable.class);
        this.presenter.showError("uuid1", error);
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((ErrorEvent)ArgumentMatchers.any(ErrorEvent.class)));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showStatusPanel(Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testShowErrorMessage() {
        this.presenter.showError("uuid1", "errorMessage");
        ((EventSourceMock)Mockito.verify(this.errorEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((ErrorEvent)ArgumentMatchers.any(ErrorEvent.class)));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showStatusPanel(Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()), Boolean.valueOf(Mockito.anyBoolean()));
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanelIcon((IconType)ArgumentMatchers.any(IconType.class), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), Mockito.anyBoolean());
        ((DataSetSummary.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showSizePanel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }
}

