/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor;

import com.google.gwt.editor.client.EditorDelegate;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.widgets.common.LoadingBox;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefColumnsFilterEditor;
import org.dashbuilder.client.widgets.dataset.editor.DataSetDefPreviewTable;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBackendCacheAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBasicAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefCacheAttributesEditorView;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefClientCacheAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefRefreshAttributesEditor;
import org.dashbuilder.client.widgets.dataset.event.ColumnsChangedEvent;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.dataset.event.FilterChangedEvent;
import org.dashbuilder.client.widgets.dataset.event.TabChangedEvent;
import org.dashbuilder.client.widgets.resources.i18n.DataSetEditorConstants;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.DataSetDefEditor;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

public abstract class DataSetEditor<T extends DataSetDef>
implements IsWidget,
DataSetDefEditor<T> {
    public static final String TAB_CONFIGURATION = "configuration";
    public static final String TAB_PREVIEW = "preview";
    public static final String TAB_ADVANCED = "advanced";
    protected DataSetDefBasicAttributesEditor basicAttributesEditor;
    protected IsWidget providerAttributesEditorView;
    protected DataSetDefColumnsFilterEditor columnsAndFilterEditor;
    protected DataSetDefPreviewTable previewTable;
    protected DataSetDefBackendCacheAttributesEditor backendCacheAttributesEditor;
    protected DataSetDefClientCacheAttributesEditor clientCacheAttributesEditor;
    private DataSetDefRefreshAttributesEditor refreshEditor;
    protected DataSetClientServices clientServices;
    protected LoadingBox loadingBox;
    protected Event<ErrorEvent> errorEvent;
    protected Event<TabChangedEvent> tabChangedEvent;
    public View view;
    protected DataSetDef dataSetDef;
    protected Command afterPreviewCommand;
    protected final Command configurationTabItemClickHandler = new Command(){

        public void execute() {
            DataSetEditor.this.tabChangedEvent.fire((Object)new TabChangedEvent(DataSetEditor.this, DataSetEditor.TAB_CONFIGURATION));
        }
    };
    protected final Command previewTabItemClickHandler = new Command(){

        public void execute() {
            DataSetEditor.this.tabChangedEvent.fire((Object)new TabChangedEvent(DataSetEditor.this, DataSetEditor.TAB_PREVIEW));
        }
    };
    protected final Command advancedTabItemClickHandler = new Command(){

        public void execute() {
            DataSetEditor.this.tabChangedEvent.fire((Object)new TabChangedEvent(DataSetEditor.this, DataSetEditor.TAB_ADVANCED));
        }
    };

    @Inject
    public DataSetEditor(DataSetDefBasicAttributesEditor basicAttributesEditor, IsWidget providerAttributesEditorView, DataSetDefColumnsFilterEditor columnsAndFilterEditor, DataSetDefPreviewTable previewTable, DataSetDefBackendCacheAttributesEditor backendCacheAttributesEditor, DataSetDefClientCacheAttributesEditor clientCacheAttributesEditor, DataSetDefRefreshAttributesEditor refreshEditor, DataSetClientServices clientServices, LoadingBox loadingBox, Event<ErrorEvent> errorEvent, Event<TabChangedEvent> tabChangedEvent, View view) {
        this.basicAttributesEditor = basicAttributesEditor;
        this.providerAttributesEditorView = providerAttributesEditorView;
        this.columnsAndFilterEditor = columnsAndFilterEditor;
        this.previewTable = previewTable;
        this.backendCacheAttributesEditor = backendCacheAttributesEditor;
        this.clientCacheAttributesEditor = clientCacheAttributesEditor;
        this.refreshEditor = refreshEditor;
        this.clientServices = clientServices;
        this.loadingBox = loadingBox;
        this.errorEvent = errorEvent;
        this.tabChangedEvent = tabChangedEvent;
        this.view = view;
    }

    public void init() {
        this.view.init(this);
        this.view.initWidgets(this.basicAttributesEditor.view, this.providerAttributesEditorView, this.columnsAndFilterEditor.view, this.previewTable.view, this.backendCacheAttributesEditor.view, this.clientCacheAttributesEditor.view, this.refreshEditor.view);
        this.view.addConfigurationTabItemClickHandler(this.configurationTabItemClickHandler);
        this.view.addPreviewTabItemClickHandler(this.previewTabItemClickHandler);
        this.view.addAdvancedTabItemClickHandler(this.advancedTabItemClickHandler);
        this.columnsAndFilterEditor.setMaxHeight("400px");
        this.backendCacheAttributesEditor.setRange(200.0, 10000.0);
        this.clientCacheAttributesEditor.setRange(0.0, 4096.0);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void showConfigurationTab() {
        this.afterPreviewCommand = new Command(){

            public void execute() {
                DataSetEditor.this.view.showConfigurationTab();
            }
        };
    }

    public void showPreviewTab() {
        this.afterPreviewCommand = new Command(){

            public void execute() {
                DataSetEditor.this.view.showPreviewTab();
            }
        };
    }

    public void showAdvancedTab() {
        this.afterPreviewCommand = new Command(){

            public void execute() {
                DataSetEditor.this.view.showAdvancedTab();
            }
        };
    }

    public void setAcceptableValues(List<DataColumnDef> acceptableValues) {
        this.columnsAndFilterEditor.setAcceptableValues(acceptableValues);
    }

    public void flush() {
    }

    public void onPropertyChange(String ... paths) {
    }

    public void setValue(T value) {
        boolean isBean;
        this.dataSetDef = value;
        DataSetProviderType type = value.getProvider() != null ? value.getProvider() : null;
        String typeTitle = this.getTypeTitle(type);
        this.view.setConfigurationTabTitle(new StringBuffer(typeTitle).append(" ").append(DataSetEditorConstants.INSTANCE.tab_configguration()).toString());
        boolean bl = isBean = type != null && DataSetProviderType.BEAN.equals((Object)type);
        if (isBean) {
            this.backendCacheAttributesEditor = null;
        }
        this.doPreview(true);
    }

    public void setDelegate(EditorDelegate<T> delegate) {
    }

    public org.dashbuilder.dataset.client.editor.DataSetDefBasicAttributesEditor basicAttributesEditor() {
        return this.basicAttributesEditor;
    }

    public org.dashbuilder.dataset.client.editor.DataSetDefColumnsFilterEditor columnsAndFilterEditor() {
        return this.columnsAndFilterEditor;
    }

    public DataSetDefBackendCacheAttributesEditor backendCacheEditor() {
        return this.backendCacheAttributesEditor;
    }

    public org.dashbuilder.dataset.client.editor.DataSetDefClientCacheAttributesEditor clientCacheEditor() {
        return this.clientCacheAttributesEditor;
    }

    public org.dashbuilder.dataset.client.editor.DataSetDefRefreshAttributesEditor refreshEditor() {
        return this.refreshEditor;
    }

    void onOpenColumnsFilterPanel() {
        this.view.openColumnsFilterPanel(DataSetEditorConstants.INSTANCE.hideColumnsAndFilter());
    }

    void onCloseColumnsFilterPanel() {
        this.view.closeColumnsFilterPanel(DataSetEditorConstants.INSTANCE.showColumnsAndFilter());
    }

    protected void doPreview(boolean isUpdateFilter) {
        this.loadingBox.show();
        this.previewTable.show(this.dataSetDef, this.dataSetDef.getColumns(), (DisplayerListener)new DataSetEditorListener(isUpdateFilter));
    }

    protected void afterPreview(DataSet dataSet, boolean isUpdateFilter) {
        this.view.clearErrorNotification();
        if (isUpdateFilter) {
            this.columnsAndFilterEditor.dataSetFilter().init(dataSet.getMetadata());
        }
        if (this.afterPreviewCommand != null) {
            this.afterPreviewCommand.execute();
            this.afterPreviewCommand = null;
        }
        this.loadingBox.hide();
    }

    protected void showError(ClientRuntimeError error) {
        this.loadingBox.hide();
        String message = error.getCause() != null ? error.getCause() : error.getMessage();
        this.view.showErrorNotification(new SafeHtmlBuilder().appendEscaped(message).toSafeHtml());
        this.errorEvent.fire((Object)new ErrorEvent(this, error));
        if (this.afterPreviewCommand != null) {
            this.afterPreviewCommand.execute();
        }
    }

    private String getTypeTitle(DataSetProviderType type) {
        if (DataSetProviderType.BEAN.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.bean();
        }
        if (DataSetProviderType.CSV.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.csv();
        }
        if (DataSetProviderType.SQL.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.sql();
        }
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)type)) {
            return DataSetEditorConstants.INSTANCE.elasticSearch();
        }
        return "";
    }

    void onColumnsChangedEvent(@Observes ColumnsChangedEvent columnsChangedEvent) {
        PortablePreconditions.checkNotNull((String)"columnsChangedEvent", (Object)((Object)columnsChangedEvent));
        if (columnsChangedEvent.getContext().equals(this.columnsAndFilterEditor.columnListEditor().columns())) {
            List<DataColumnDef> cols = columnsChangedEvent.getColumns();
            this.dataSetDef.setColumns(cols);
            this.doPreview(true);
        }
    }

    void onFilterChangedEvent(@Observes FilterChangedEvent filterChangedEvent) {
        PortablePreconditions.checkNotNull((String)"filterChangedEvent", (Object)((Object)filterChangedEvent));
        if (filterChangedEvent.getContext().equals(this.columnsAndFilterEditor.dataSetFilter())) {
            DataSetFilter f = filterChangedEvent.getFilter();
            this.dataSetDef.setDataSetFilter(f);
            this.doPreview(false);
        }
    }

    private class DataSetEditorListener
    extends AbstractDisplayerListener {
        private boolean isUpdateFilter;

        public DataSetEditorListener(boolean isUpdateFilter) {
            this.isUpdateFilter = isUpdateFilter;
        }

        public void onDraw(Displayer displayer) {
            DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
            DataSetEditor.this.afterPreview(dataSet, this.isUpdateFilter);
        }

        public void onRedraw(Displayer displayer) {
            DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
            DataSetEditor.this.afterPreview(dataSet, this.isUpdateFilter);
        }

        public void onClose(Displayer displayer) {
            DataSetEditor.this.loadingBox.hide();
        }

        public void onError(Displayer displayer, ClientRuntimeError error) {
            DataSetEditor.this.showError(error);
        }
    }

    public static interface View
    extends UberView<DataSetEditor> {
        public void initWidgets(DataSetDefBasicAttributesEditor.View var1, IsWidget var2, DataSetDefColumnsFilterEditor.View var3, DataSetDefPreviewTable.View var4, DataSetDefCacheAttributesEditorView var5, DataSetDefCacheAttributesEditorView var6, DataSetDefRefreshAttributesEditor.View var7);

        public void setConfigurationTabTitle(String var1);

        public void showConfigurationTab();

        public void addConfigurationTabItemClickHandler(Command var1);

        public void showPreviewTab();

        public void addPreviewTabItemClickHandler(Command var1);

        public void showAdvancedTab();

        public void addAdvancedTabItemClickHandler(Command var1);

        public void openColumnsFilterPanel(String var1);

        public void closeColumnsFilterPanel(String var1);

        public void showErrorNotification(SafeHtml var1);

        public void clearErrorNotification();
    }
}

