/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.csv;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.csv.CSVDataSetDefAttributesEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.editor.file.FileUploadEditor;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.impl.CSVDataSetDefBuilderImpl;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CSVDataSetDefAttributesEditorTest {
    @Mock
    DataSetClientServices dataSetClientServices;
    @Mock
    ValueBoxEditor<String> fileURL;
    @Mock
    FileUploadEditor filePath;
    @Mock
    ValueBoxEditor<Character> separatorChar;
    @Mock
    ValueBoxEditor<Character> quoteChar;
    @Mock
    ValueBoxEditor<Character> escapeChar;
    @Mock
    ValueBoxEditor<String> datePattern;
    @Mock
    ValueBoxEditor<String> numberPattern;
    @Mock
    CSVDataSetDefAttributesEditor.View view;
    private CSVDataSetDefAttributesEditor presenter;

    @Before
    public void setup() {
        ((DataSetClientServices)Mockito.doAnswer(args -> args.getArguments()[0]).when((Object)this.dataSetClientServices)).getUploadFileUrl(ArgumentMatchers.anyString());
        this.presenter = new CSVDataSetDefAttributesEditor(this.dataSetClientServices, this.fileURL, this.filePath, this.separatorChar, this.quoteChar, this.escapeChar, this.datePattern, this.numberPattern, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).initWidgets((ValueBoxEditor.View)ArgumentMatchers.any(), (IsWidget)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any());
        ((ValueBoxEditor)Mockito.verify(this.fileURL, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((FileUploadEditor)Mockito.verify((Object)this.filePath, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.separatorChar, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.quoteChar, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.escapeChar, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.datePattern, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((ValueBoxEditor)Mockito.verify(this.numberPattern, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((FileUploadEditor)Mockito.verify((Object)this.filePath, (VerificationMode)Mockito.times((int)1))).configure(ArgumentMatchers.anyString(), (FileUploadEditor.FileUploadEditorCallback)ArgumentMatchers.any(FileUploadEditor.FileUploadEditorCallback.class));
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showFilePathInput();
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showFileURLInput();
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(FileUploadEditor.FileUploadEditorCallback.class);
        ((FileUploadEditor)Mockito.verify((Object)this.filePath)).configure(ArgumentMatchers.anyString(), (FileUploadEditor.FileUploadEditorCallback)callbackCaptor.capture());
        CSVDataSetDef dataSetDef = (CSVDataSetDef)((CSVDataSetDefBuilderImpl)DataSetDefFactory.newCSVDataSetDef().uuid("test")).buildDef();
        this.presenter.setValue(dataSetDef);
        FileUploadEditor.FileUploadEditorCallback fileCallback = (FileUploadEditor.FileUploadEditorCallback)callbackCaptor.getValue();
        String fileUrl = fileCallback.getUploadFileUrl();
        Assert.assertEquals((Object)fileUrl, (Object)"default://master@dashbuilder/datasets/tmp/test.csv");
    }

    @Test
    public void testFileUrl() {
        Assert.assertEquals(this.fileURL, (Object)this.presenter.fileURL());
    }

    @Test
    public void testFilePath() {
        Assert.assertEquals((Object)this.filePath, (Object)this.presenter.filePath());
    }

    @Test
    public void testSepChar() {
        Assert.assertEquals(this.separatorChar, (Object)this.presenter.separatorChar());
    }

    @Test
    public void testQuoteChar() {
        Assert.assertEquals(this.quoteChar, (Object)this.presenter.quoteChar());
    }

    @Test
    public void testEscapeChar() {
        Assert.assertEquals(this.escapeChar, (Object)this.presenter.escapeChar());
    }

    @Test
    public void testDatePattern() {
        Assert.assertEquals(this.datePattern, (Object)this.presenter.datePattern());
    }

    @Test
    public void testNumberPattern() {
        Assert.assertEquals(this.numberPattern, (Object)this.presenter.numberPattern());
    }

    @Test
    public void testSetValueUsingFileUrl() {
        CSVDataSetDef dataSetDef = (CSVDataSetDef)Mockito.mock(CSVDataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.CSV);
        Mockito.when((Object)dataSetDef.getFileURL()).thenReturn((Object)"fileUrl");
        Mockito.when((Object)dataSetDef.getFilePath()).thenReturn(null);
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)false, (Object)this.presenter.isUsingFilePath());
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showFileURLInput();
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showFilePathInput();
    }

    @Test
    public void testSetValueUsingFilePath() {
        CSVDataSetDef dataSetDef = (CSVDataSetDef)Mockito.mock(CSVDataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.CSV);
        Mockito.when((Object)dataSetDef.getFileURL()).thenReturn(null);
        Mockito.when((Object)dataSetDef.getFilePath()).thenReturn((Object)"filePath");
        this.presenter.setValue(dataSetDef);
        Assert.assertEquals((Object)true, (Object)this.presenter.isUsingFilePath());
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showFilePathInput();
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showFileURLInput();
    }

    public void testCallbackUseFileUrl() {
        this.presenter.onUseFileURLButtonClick();
        Assert.assertEquals((Object)false, (Object)this.presenter.isUsingFilePath());
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showFileURLInput();
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showFilePathInput();
    }

    public void testCallbackUseFilePath() {
        this.presenter.onUseFilePathButtonClick();
        Assert.assertEquals((Object)true, (Object)this.presenter.isUsingFilePath());
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).initWidgets((ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showFilePathInput();
        ((CSVDataSetDefAttributesEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showFileURLInput();
    }
}

