/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.widgets.dataset.editor.attributes;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefBackendCacheAttributesEditor;
import org.dashbuilder.client.widgets.dataset.editor.attributes.DataSetDefCacheAttributesEditorView;
import org.dashbuilder.common.client.editor.ToggleSwitchEditor;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefBackendCacheAttributesEditorTest {
    @Mock
    ToggleSwitchEditor cacheEnabled;
    @Mock
    ValueBoxEditor<Integer> cacheMaxRows;
    @Mock
    DataSetDefCacheAttributesEditorView view;
    private DataSetDefBackendCacheAttributesEditor presenter;

    @Before
    public void setup() {
        this.presenter = new DataSetDefBackendCacheAttributesEditor(this.cacheEnabled, this.cacheMaxRows, this.view);
    }

    @Test
    public void testInit() {
        this.presenter.init();
        ((ValueBoxEditor)Mockito.verify(this.cacheMaxRows, (VerificationMode)Mockito.times((int)1))).addHelpContent(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Placement)ArgumentMatchers.any(Placement.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(), (ValueBoxEditor.View)ArgumentMatchers.any());
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEnabled(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testSetRange() {
        this.presenter.setRange(Double.valueOf(1.0), Double.valueOf(2.0));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRange(Double.valueOf(1.0), Double.valueOf(2.0));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEnabled(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testCacheEnabled() {
        Assert.assertEquals((Object)this.cacheEnabled, (Object)this.presenter.cacheEnabled());
    }

    @Test
    public void testCacheMaxRows() {
        Assert.assertEquals(this.cacheMaxRows, (Object)this.presenter.cacheMaxRows());
    }

    @Test
    public void testSetValueEnabled() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.isCacheEnabled()).thenReturn((Object)true);
        this.presenter.setValue(dataSetDef);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
    }

    @Test
    public void testSetValueDisabled() {
        DataSetDef dataSetDef = (DataSetDef)Mockito.mock(DataSetDef.class);
        Mockito.when((Object)dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)dataSetDef.isCacheEnabled()).thenReturn((Object)false);
        this.presenter.setValue(dataSetDef);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
    }

    @Test
    public void testViewCallback() {
        Double value = 1.0;
        this.presenter.viewCallback.onValueChange(value);
        ((ValueBoxEditor)Mockito.verify(this.cacheMaxRows, (VerificationMode)Mockito.times((int)1))).setValue((Object)ArgumentMatchers.anyInt());
        ((ToggleSwitchEditor)Mockito.verify((Object)this.cacheEnabled, (VerificationMode)Mockito.times((int)0))).setValue(Boolean.valueOf(ArgumentMatchers.anyBoolean()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEnabled(ArgumentMatchers.anyBoolean());
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
    }

    @Test
    public void testViewCallbackNullified() {
        Double value = null;
        this.presenter.viewCallback.onValueChange(value);
        ((ValueBoxEditor)Mockito.verify(this.cacheMaxRows, (VerificationMode)Mockito.times((int)1))).setValue((Object)100);
        ((ToggleSwitchEditor)Mockito.verify((Object)this.cacheEnabled, (VerificationMode)Mockito.times((int)0))).setValue(Boolean.valueOf(ArgumentMatchers.anyBoolean()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEnabled(ArgumentMatchers.anyBoolean());
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
    }

    public void testOnEnabledChangedEventUsingTrue() {
        ValueChangeEvent event = (ValueChangeEvent)Mockito.mock(ValueChangeEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.cacheEnabled);
        Mockito.when((Object)((Boolean)event.getValue())).thenReturn((Object)true);
        this.presenter.onEnabledChangedEvent(event);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(true);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
    }

    public void testOnEnabledChangedEventUsingFalse() {
        ValueChangeEvent event = (ValueChangeEvent)Mockito.mock(ValueChangeEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.cacheEnabled);
        Mockito.when((Object)((Boolean)event.getValue())).thenReturn((Object)false);
        this.presenter.onEnabledChangedEvent(event);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(false);
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRange(Double.valueOf(ArgumentMatchers.anyDouble()), Double.valueOf(ArgumentMatchers.anyDouble()));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (IsWidget)ArgumentMatchers.any(IsWidget.class), (ValueBoxEditor.View)ArgumentMatchers.any(ValueBoxEditor.View.class));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)((DataSetDefCacheAttributesEditorView.ViewCallback)ArgumentMatchers.any(DataSetDefCacheAttributesEditorView.ViewCallback.class)));
        ((DataSetDefCacheAttributesEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Double.valueOf(ArgumentMatchers.anyDouble()));
    }
}

