/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import org.databene.contiperf.InvocationRunner;
import org.databene.contiperf.PerfTestExecutionError;
import org.databene.contiperf.util.ContiPerfUtil;

public class ConcurrentRunner
implements InvocationRunner {
    private String name;
    private InvocationRunner[] runners;

    public ConcurrentRunner(String name, InvocationRunner[] runners) {
        this.name = name;
        this.runners = runners;
    }

    public void run() {
        CPThreadGroup threadGroup;
        block6: {
            threadGroup = new CPThreadGroup(this.name);
            Thread[] threads = new Thread[this.runners.length];
            for (int i = 0; i < this.runners.length; ++i) {
                threads[i] = new Thread((ThreadGroup)threadGroup, this.runners[i]);
            }
            for (Thread thread : threads) {
                thread.start();
            }
            try {
                for (Thread thread : threads) {
                    thread.join();
                }
            }
            catch (InterruptedException e) {
                if (threadGroup.throwable != null) break block6;
                throw new PerfTestExecutionError(e);
            }
        }
        if (threadGroup.throwable != null) {
            throw ContiPerfUtil.executionError(threadGroup.throwable);
        }
    }

    public void close() {
        for (InvocationRunner runner : this.runners) {
            runner.close();
        }
        this.runners = null;
    }

    class CPThreadGroup
    extends ThreadGroup {
        Throwable throwable;

        public CPThreadGroup(String name) {
            super(name);
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (this.throwable == null) {
                this.throwable = throwable;
            }
            this.interrupt();
        }
    }
}

