/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import java.util.concurrent.atomic.AtomicLong;
import org.databene.contiperf.ArgumentsProvider;
import org.databene.contiperf.InvocationRunner;
import org.databene.contiperf.Invoker;
import org.databene.contiperf.util.ContiPerfUtil;

public class CountRunner
implements InvocationRunner {
    private ArgumentsProvider argsProvider;
    private Invoker invoker;
    private AtomicLong invocationsLeft;
    private boolean yield;

    public CountRunner(Invoker invoker, ArgumentsProvider argsProvider, AtomicLong invocationsLeft, boolean yield) {
        this.invoker = invoker;
        this.argsProvider = argsProvider;
        this.invocationsLeft = invocationsLeft;
        this.yield = yield;
    }

    public void run() {
        try {
            while (this.invocationsLeft.getAndDecrement() > 0L) {
                this.invoker.invoke(this.argsProvider.next());
                if (!this.yield) continue;
                Thread.yield();
            }
        }
        catch (Exception e) {
            throw ContiPerfUtil.executionError(e);
        }
    }

    public void close() {
        this.invoker = null;
    }
}

