/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import java.io.PrintWriter;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.Invoker;
import org.databene.contiperf.PercentileRequirement;
import org.databene.contiperf.PerfTestFailure;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.util.InvokerProxy;
import org.databene.stat.LatencyCounter;

public class PerformanceTracker
extends InvokerProxy {
    private PerformanceRequirement requirement;
    private boolean cancelOnViolation;
    private ExecutionLogger logger;
    private LatencyCounter counter;
    private boolean started;

    public PerformanceTracker(Invoker target, PerformanceRequirement requirement, ExecutionLogger logger) {
        this(target, requirement, true, logger);
    }

    public PerformanceTracker(Invoker target, PerformanceRequirement requirement, boolean cancelOnViolation, ExecutionLogger logger) {
        super(target);
        this.requirement = requirement;
        this.setExecutionLogger(logger);
        this.started = false;
        this.cancelOnViolation = cancelOnViolation;
    }

    public void setExecutionLogger(ExecutionLogger logger) {
        this.logger = logger;
    }

    public LatencyCounter getCounter() {
        return this.counter;
    }

    public void start() {
        int max = this.requirement != null ? this.requirement.getMax() : -1;
        this.counter = new LatencyCounter(max >= 0 ? max : 1000);
        this.counter.start();
        this.started = true;
    }

    public Object invoke(Object[] args) throws Exception {
        if (!this.started) {
            this.start();
        }
        long callStart = System.nanoTime();
        Object result = super.invoke(args);
        int latency = (int)((System.nanoTime() - callStart) / 1000000L);
        this.counter.addSample(latency);
        this.logger.logInvocation(this.getId(), latency, callStart);
        if (this.requirement != null && this.requirement.getMax() >= 0 && latency > this.requirement.getMax() && this.cancelOnViolation) {
            throw new PerfTestFailure("Method " + this.getId() + " exceeded time limit of " + this.requirement.getMax() + " ms running " + latency + " ms");
        }
        return result;
    }

    public void stop() {
        this.counter.stop();
        this.counter.printSummary(new PrintWriter(System.out), new int[0]);
        long elapsedTime = this.counter.duration();
        this.logger.logSummary(this.getId(), elapsedTime, this.counter.sampleCount(), this.counter.getStartTime());
        if (this.requirement != null) {
            this.checkRequirements(elapsedTime);
        }
    }

    public void clear() {
        this.counter = null;
    }

    private void checkRequirements(long elapsedMillis) throws PerfTestFailure {
        long actualThroughput;
        long requiredMax = this.requirement.getMax();
        if (requiredMax >= 0L && this.counter.maxLatency() > requiredMax) {
            throw new PerfTestFailure("The maximum latency of " + requiredMax + " ms was exceeded, Measured: " + elapsedMillis + " ms");
        }
        long requiredTotalTime = this.requirement.getTotalTime();
        if (requiredTotalTime >= 0L && elapsedMillis > requiredTotalTime) {
            throw new PerfTestFailure("Test run " + this.getId() + " exceeded timeout of " + requiredTotalTime + " ms running " + elapsedMillis + " ms");
        }
        int requiredThroughput = this.requirement.getThroughput();
        if (requiredThroughput > 0 && (actualThroughput = this.counter.sampleCount() * 1000L / elapsedMillis) < (long)requiredThroughput) {
            throw new PerfTestFailure("Test " + this.getId() + " had a throughput of only " + actualThroughput + " calls per second, required: " + requiredThroughput + " calls per second");
        }
        int requiredAverage = this.requirement.getAverage();
        if (requiredAverage >= 0 && this.counter.averageLatency() > (double)requiredAverage) {
            throw new PerfTestFailure("Average execution time of " + this.getId() + " exceeded the requirement of " + requiredAverage + " ms, measured " + this.counter.averageLatency() + " ms");
        }
        for (PercentileRequirement percentile : this.requirement.getPercentileRequirements()) {
            long measuredLatency = this.counter.percentileLatency(percentile.getPercentage());
            if (measuredLatency <= (long)percentile.getMillis()) continue;
            throw new PerfTestFailure(percentile.getPercentage() + "-percentile of " + this.getId() + " exceeded the requirement of " + percentile.getMillis() + " ms, measured " + measuredLatency + " ms");
        }
    }
}

