/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf;

import org.databene.contiperf.ArgumentsProvider;
import org.databene.contiperf.InvocationRunner;
import org.databene.contiperf.Invoker;
import org.databene.contiperf.util.ContiPerfUtil;

public class TimedRunner
implements InvocationRunner {
    private long duration;
    private ArgumentsProvider argsProvider;
    private Invoker invoker;

    public TimedRunner(Invoker invoker, ArgumentsProvider argsProvider, long duration) {
        this.invoker = invoker;
        this.argsProvider = argsProvider;
        this.duration = duration;
    }

    public void run() {
        try {
            long start = System.currentTimeMillis();
            long endTime = start + this.duration;
            do {
                this.invoker.invoke(this.argsProvider.next());
            } while (System.currentTimeMillis() < endTime);
        }
        catch (Exception e) {
            throw ContiPerfUtil.executionError(e);
        }
    }

    public void close() {
        this.invoker = null;
    }
}

